/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFMarkInfo;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureClassMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureIDTree;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureParentTree;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import java.util.Iterator;

public class PDFStructureRoot
extends PDFStructureNode {
    private PDFStructureRoot(CosObject cosObj) throws PDFInvalidDocumentException {
        super(cosObj);
    }

    private PDFStructureRoot(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_StructTreeRoot);
    }

    public static PDFStructureRoot getInstance(CosDictionary cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureRoot pdfObject = (PDFStructureRoot)PDFCosObject.getCachedInstance(cosObject, PDFStructureRoot.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureRoot(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureRoot newInstance(PDFDocument forDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCatalog catalogDict = forDoc.requireCatalog();
        if (catalogDict.hasStructureRoot()) {
            return null;
        }
        PDFStructureRoot structRoot = new PDFStructureRoot(forDoc);
        PDFMarkInfo markInfoDict = PDFMarkInfo.getInstance(forDoc.getCosDocument().createDirectCosDictionary());
        markInfoDict.setMarked(true);
        catalogDict.setStructureRoot(structRoot);
        catalogDict.setMarkInfo(markInfoDict);
        return structRoot;
    }

    public static PDFStructureRoot newInstance(PDFDocument forDoc, PDFStructureElement firstChild) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureRoot structRoot = PDFStructureRoot.newInstance(forDoc);
        if (structRoot == null) {
            return null;
        }
        structRoot.addContent(firstChild);
        return structRoot;
    }

    @Override
    public PDFStructureType getStructureType() {
        return PDFStructureType.Root;
    }

    public PDFStructureParentTree getParentTree() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureParentTree.getInstance(this.getCosDictionary().get(ASName.k_ParentTree));
    }

    public PDFStructureParentTree procureParentTree() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureParentTree parentTree = this.getParentTree();
        if (parentTree == null) {
            parentTree = PDFStructureParentTree.newInstance(this.getPDFDocument());
            this.getCosDictionary().put(ASName.k_ParentTree, parentTree.getCosObject());
            this.setNextParentKey(0);
        }
        return parentTree;
    }

    public int addParentTree(PDFStructureContentInterface node) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        Integer n;
        PDFStructureParentTree parentTree = this.procureParentTree();
        Integer lastKey = this.getNextParentKey();
        if (lastKey == null) {
            lastKey = Integer.MIN_VALUE;
            Iterator itr = parentTree.keyIterator();
            while (itr.hasNext()) {
                lastKey = Math.max(lastKey, (Integer)itr.next());
            }
            n = lastKey;
            Integer n2 = lastKey = Integer.valueOf(lastKey + 1);
        }
        Integer n3 = lastKey;
        n = lastKey = Integer.valueOf(lastKey + 1);
        parentTree.addEntry(n3, node);
        this.setNextParentKey(lastKey);
        return lastKey;
    }

    public PDFStructureRoleMap getRoleMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureRoleMap.getInstance(this.getCosDictionary().get(ASName.k_RoleMap));
    }

    public void setRoleMap(PDFStructureRoleMap roleMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.k_RoleMap, roleMap.getCosObject());
    }

    public PDFStructureClassMap getClassMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureClassMap.getInstance(this.getCosDictionary().get(ASName.k_ClassMap));
    }

    public void setClassMap(PDFStructureClassMap classMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.k_ClassMap, classMap.getCosObject());
    }

    public void removeParentTree() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().remove(ASName.k_ParentTree);
    }

    public PDFStructureIDTree getIdTree() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureIDTree.getInstance(this.getCosDictionary().get(ASName.k_IDTree));
    }

    public void setIDTree(PDFStructureIDTree idTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.k_IDTree, idTree.getCosObject());
    }

    public Integer getNextParentKey() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_ParentTreeNextKey);
    }

    public void setNextParentKey(int key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.k_ParentTreeNextKey, key);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }
}

