/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class PDFStructureRoleMap
extends PDFCosDictionary {
    private PDFStructureRoleMap(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFStructureRoleMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureRoleMap pdfObject = (PDFStructureRoleMap)PDFCosObject.getCachedInstance(cosObject, PDFStructureRoleMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureRoleMap(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureRoleMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFStructureRoleMap(cosObject);
    }

    public void addRole(ASName role, ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(role, type);
    }

    public ASName getRole(ASName role) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashSet<ASName> visited = new HashSet<ASName>();
        ASName type = null;
        while (role != null && !visited.contains(role)) {
            visited.add(role);
            if ((role = this.getDictionaryNameValue(role)) == null) continue;
            type = role;
        }
        return type;
    }

    public LinkedHashSet collectRoles() {
        return new LinkedHashSet<ASName>(this.getCosDictionary().keySet());
    }
}

