/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentScalar;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class PDFStructureOBJR
extends PDFStructureContentScalar {
    private PDFStructureOBJR(CosObject item) throws PDFInvalidDocumentException {
        super(item);
    }

    public static PDFStructureOBJR getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureOBJR pdfObject = (PDFStructureOBJR)PDFCosObject.getCachedInstance(cosObject, PDFStructureOBJR.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureOBJR(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureOBJR newInstance(PDFDocument pdfDoc, PDFPage page, PDFCosObject refObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary objrDict = PDFCosObject.newCosDictionary(pdfDoc);
        objrDict.put(ASName.k_Type, ASName.k_OBJR);
        if (page != null) {
            objrDict.put(ASName.k_Pg, page.getCosObject());
        }
        if (refObj != null) {
            objrDict.put(ASName.k_Obj, refObj.getCosObject());
        }
        return new PDFStructureOBJR(objrDict);
    }

    public boolean containsOBJ(PDFCosObject refObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (refObj == null) {
            return false;
        }
        CosObject refCosObj = refObj.getCosObject();
        CosDictionary thisDict = (CosDictionary)this.getCosObject();
        if (thisDict != null) {
            return refCosObj == thisDict.get(ASName.k_Obj);
        }
        return false;
    }

    @Override
    public PDFPage getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPage.getInstance(((CosDictionary)this.contentItem).getCosDictionary(ASName.k_Pg));
    }

    public void setPage(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (page == null) {
            this.removeValue(ASName.k_Pg);
        } else {
            this.setDictionaryValue(ASName.k_Pg, page.getCosObject());
        }
    }

    public void setOBJR(PDFCosObject refObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (refObj == null) {
            this.removeValue(ASName.k_Obj);
        } else {
            this.setDictionaryValue(ASName.k_Obj, refObj.getCosObject());
        }
    }

    @Override
    public PDFStructureType getStructureType() {
        return PDFStructureType.OBJR;
    }
}

