/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.prepress;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFPrepressUtils;

public class PDFSeparationInfo
extends PDFCosDictionary {
    private PDFSeparationInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSeparationInfo newInstance(PDFDocument pdfDocument, CosArray key_Pages, ASName key_DeviceColorant) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Pages == null) {
            throw new PDFInvalidParameterException("Pages is required when creating newInstance of PDFSeparationInfo.");
        }
        if (key_DeviceColorant == null) {
            throw new PDFInvalidParameterException("DeviceColorant is required when creating newInstance of PDFSeparationInfo.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFSeparationInfo pdfObject = new PDFSeparationInfo(cosObject);
        pdfObject.setPages(key_Pages);
        pdfObject.setDeviceColorant(key_DeviceColorant);
        return pdfObject;
    }

    public static PDFSeparationInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSeparationInfo pdfObject = (PDFSeparationInfo)PDFCosObject.getCachedInstance(cosObject, PDFSeparationInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFSeparationInfo(cosObject);
        }
        return pdfObject;
    }

    public CosArray getPages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Pages);
    }

    public void setPages(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Pages is a required key therefore cannot be removed.");
        }
        if (!PDFPrepressUtils.validatePagesArray(value)) {
            throw new PDFInvalidParameterException("Invalid Page Array. Invalid Object Number: " + value.getObjNum());
        }
        this.setDictionaryValue(ASName.k_Pages, value);
    }

    public boolean hasPages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Pages);
    }

    public ASName getDeviceColorantAsName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_DeviceColorant);
    }

    public void setDeviceColorant(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("DeviceColorant is a required key therefore cannot be removed.");
        }
        this.setDictionaryNameValue(ASName.k_DeviceColorant, value);
    }

    public ASString getDeviceColorantAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_DeviceColorant);
    }

    public void setDeviceColorant(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("DeviceColorant is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_DeviceColorant, value);
    }

    public void setDeviceColorant(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("DeviceColorant is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_DeviceColorant, value);
    }

    public boolean hasDeviceColorant() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_DeviceColorant);
    }

    public CosArray getColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_ColorSpace);
    }

    public void setColorSpace(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_ColorSpace, value);
    }

    public boolean hasColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ColorSpace);
    }
}

