/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.prepress;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOPIColorArray;

public class PDFOPI1_3
extends PDFCosDictionary {
    private PDFOPI1_3(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOPI1_3 newInstance(PDFDocument pdfDocument, CosArray key_Size, PDFFileSpecification key_F, double key_Version, CosArray key_CropRect, CosArray key_Position) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Size == null) {
            throw new PDFInvalidParameterException("Size is required when creating newInstance of PDFOPI1_3.");
        }
        if (key_F == null) {
            throw new PDFInvalidParameterException("F is required when creating newInstance of PDFOPI1_3.");
        }
        if (key_CropRect == null) {
            throw new PDFInvalidParameterException("CropRect is required when creating newInstance of PDFOPI1_3.");
        }
        if (key_Position == null) {
            throw new PDFInvalidParameterException("Position is required when creating newInstance of PDFOPI1_3.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFOPI1_3 pdfObject = new PDFOPI1_3(cosObject);
        pdfObject.setSize(key_Size);
        pdfObject.setFileSpecification(key_F);
        pdfObject.setVersion();
        pdfObject.setCropRect(key_CropRect);
        pdfObject.setPosition(key_Position);
        return pdfObject;
    }

    public static PDFOPI1_3 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOPI1_3 pdfObject = (PDFOPI1_3)PDFCosObject.getCachedInstance(cosObject, PDFOPI1_3.class);
        if (pdfObject == null) {
            pdfObject = new PDFOPI1_3(cosObject);
        }
        pdfObject.setVersion();
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.create("OPI"))) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Type.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public double getTint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Tint);
    }

    public void setTint(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Tint, value);
    }

    public boolean hasTint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Tint);
    }

    public PDFOPIColorArray getColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFOPIColorArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_Color));
    }

    public void setColor(PDFOPIColorArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            this.removeValue(ASName.k_Color);
        } else {
            this.setDictionaryArrayValue(ASName.k_Color, children.getCosArray());
        }
    }

    public boolean hasColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Color);
    }

    public ASName getColorType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_ColorType);
    }

    public void setColorType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_ColorType);
        } else if (value.equals(ASName.create("Process")) || value.equals(ASName.create("Spot")) || value.equals(ASName.create("Separation"))) {
            this.setDictionaryNameValue(ASName.k_ColorType, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for ColorType.");
        }
    }

    public boolean hasColorType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ColorType);
    }

    public CosArray getGrayMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_GrayMap);
    }

    public void setGrayMap(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_GrayMap, value);
    }

    public boolean hasGrayMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_GrayMap);
    }

    public CosArray getTags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Tags);
    }

    public void setTags(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Tags, value);
    }

    public boolean hasTags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Tags);
    }

    public CosArray getCropFixed() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_CropFixed);
    }

    public void setCropFixed(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_CropFixed, value);
    }

    public boolean hasCropFixed() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CropFixed);
    }

    public boolean getTransparency() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Transparency);
    }

    public void setTransparency(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Transparency, value);
    }

    public boolean hasTransparency() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Transparency);
    }

    public CosArray getImageType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_ImageType);
    }

    public void setImageType(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_ImageType, value);
    }

    public boolean hasImageType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ImageType);
    }

    public boolean getOverprint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Overprint);
    }

    public void setOverprint(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Overprint, value);
    }

    public boolean hasOverprint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Overprint);
    }

    public double getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Version);
    }

    private void setVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Version, 1.3);
    }

    public double requireVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Version);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Version.");
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public boolean hasVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Version);
    }

    public CosArray getSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Size);
    }

    public void setSize(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Size is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Size, value);
    }

    public boolean hasSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Size);
    }

    public PDFFileSpecification getFileSpecificationAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public void setFileSpecification(PDFFileSpecification value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_F, value);
    }

    public ASString getFileSpecificationAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_F);
    }

    public void setFileSpecification(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_F, value);
    }

    public void setFileSpecification(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_F, value);
    }

    public boolean hasFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public CosArray getPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Position);
    }

    public void setPosition(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Position is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Position, value);
    }

    public boolean hasPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Position);
    }

    public ASString getComments() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_Comments);
    }

    public void setComments(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_Comments, value);
    }

    public void setComments(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_Comments, value);
    }

    public boolean hasComments() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Comments);
    }

    public CosArray getCropRect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_CropRect);
    }

    public void setCropRect(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("CropRect is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_CropRect, value);
    }

    public boolean hasCropRect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CropRect);
    }

    public CosArray getResolution() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Resolution);
    }

    public void setResolution(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Resolution, value);
    }

    public boolean hasResolution() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Resolution);
    }

    public ASString getID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_ID);
    }

    public void setID(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_ID, value);
    }

    public void setID(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_ID, value);
    }

    public boolean hasID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ID);
    }
}

