/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.prepress;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;

public class PDFOPI
extends PDFCosDictionary {
    public static final double OPI_VERSION_1_3 = 1.3;
    public static final double OPI_VERSION_2_0 = 2.0;

    protected PDFOPI(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    protected PDFOPI(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDoc));
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_OPI);
    }

    public static PDFOPI getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOPI pdfObject = (PDFOPI)PDFCosObject.getCachedInstance(cosObject, PDFOPI.class);
        if (pdfObject == null) {
            pdfObject = new PDFOPI(cosObject);
        }
        return pdfObject;
    }

    public Number getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNumericValue(ASName.k_Version);
    }

    public PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public double requireVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Version);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Version.");
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public boolean hasVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Version);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public void setFileSpecification(PDFFileSpecification value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_F, value);
    }

    public ASString getFileSpecificationAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_F);
    }

    public void setFileSpecification(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_F, value);
    }

    public void setFileSpecification(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_F, value);
    }

    public boolean hasFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public CosArray getSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Size);
    }

    protected void setSize(CosArray value, boolean isRequired) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            if (isRequired) {
                throw new PDFInvalidParameterException("Size is a required key therefore cannot be removed.");
            }
            this.removeValue(ASName.k_Size);
        } else {
            if (value.size() != 2 || value.get(0).getType() != 1 || value.get(1).getType() != 1) {
                throw new PDFInvalidParameterException("Invalid Size Array, Object number: " + value.getObjNum());
            }
            this.setDictionaryValue(ASName.k_Size, value);
        }
    }

    public boolean hasSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Size);
    }

    public CosArray getTags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Tags);
    }

    public void setTags(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Tags);
        } else {
            this.setDictionaryValue(ASName.k_Tags, value);
        }
    }

    public boolean hasTags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Tags);
    }
}

