/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionData;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionUtil;

public class PDFCollectionItemData
extends PDFCosObject
implements PDFCollectionData {
    boolean mIsText = false;
    boolean mIsDate = false;
    boolean mIsNumber = false;
    ASName mFieldName = null;
    boolean mChecked = false;
    boolean mIsValid = false;

    private PDFCollectionItemData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCollectionItemData getInstance(CosObject cosObject, ASName name) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionItemData pdfObject = (PDFCollectionItemData)PDFCosObject.getCachedInstance(cosObject, PDFCollectionItemData.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionItemData(cosObject);
        }
        pdfObject.mFieldName = name;
        return pdfObject;
    }

    public static PDFCollectionItemData newInstance(PDFDocument pdfDoc, ASDate date, ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosString cosData = PDFCosObject.newCosString(pdfDoc, date.asString());
        return PDFCollectionItemData.getInstance(cosData, key);
    }

    public static PDFCollectionItemData newInstance(PDFDocument pdfDoc, Number number, ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosData = PDFCosObject.newCosNumeric(pdfDoc, number);
        return PDFCollectionItemData.getInstance(cosData, key);
    }

    public static PDFCollectionItemData newInstance(PDFDocument pdfDoc, String text, ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosString cosData = PDFCosObject.newCosString(pdfDoc, text);
        return PDFCollectionItemData.getInstance(cosData, key);
    }

    public boolean isValid() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionUtil.checkPDFCollectionItemData(this.mFieldName, this);
        return this.mIsValid;
    }

    public boolean isDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionUtil.checkPDFCollectionItemData(this.mFieldName, this);
        return this.mIsDate;
    }

    public boolean isText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionUtil.checkPDFCollectionItemData(this.mFieldName, this);
        return this.mIsText;
    }

    public boolean isNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionUtil.checkPDFCollectionItemData(this.mFieldName, this);
        return this.mIsNumber;
    }

    public ASDate getDate() throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        if (!this.isDate()) {
            return null;
        }
        try {
            return new ASDate(this.getCosObject().stringValue());
        }
        catch (PDFParseException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public String getText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.isText()) {
            return null;
        }
        PDFText text = PDFText.getInstance(this.getCosObject());
        return text.stringValue();
    }

    public Number getNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.isNumber()) {
            return null;
        }
        return this.getCosObject().numberValue();
    }
}

