/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.agl.text.Collator;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionField;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFolder;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItem;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItemComparator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSchema;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSort;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSortItem;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSortIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;
import java.util.Comparator;

public class PDFCollectionFolderComparator
implements Comparator {
    private PDFCollectionSortItem[] mSortItems;
    private PDFCollectionSchema mSchema = null;
    private Collator mCollator;

    public PDFCollectionFolderComparator(PDFCollectionSort sort, Collator collator) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int sortInd = 0;
        this.mCollator = collator;
        PDFCollectionSortIterator nameIter = sort.getSortIterator();
        this.mSortItems = new PDFCollectionSortItem[nameIter.size()];
        while (nameIter.hasNext()) {
            this.mSortItems[sortInd++] = nameIter.nextItem();
        }
        PDFPortableCollection collection = sort.getPDFDocument().requireCatalog().getCollection();
        if (collection == null) {
            throw new PDFInvalidDocumentException("Collection is not defined");
        }
        this.mSchema = collection.getSchema();
        if (this.mSchema == null) {
            throw new PDFInvalidDocumentException("Collection Schema is not defined");
        }
    }

    public PDFCollectionFolderComparator(PDFCollectionSort sort) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this(sort, null);
    }

    public int compare(Object arg0, Object arg1) {
        PDFCollectionFolder first = (PDFCollectionFolder)arg0;
        PDFCollectionFolder second = (PDFCollectionFolder)arg1;
        int compared = 0;
        int sortInd = 0;
        while (sortInd < this.mSortItems.length && compared == 0) {
            try {
                compared = this.compareFolders(first, second, sortInd++);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return compared;
    }

    private int compareFolders(PDFCollectionFolder first, PDFCollectionFolder second, int sortInd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFParseException {
        int compared = 0;
        PDFCollectionSortItem sortItem = this.mSortItems[sortInd];
        int direction = sortItem.getOrder() ? 1 : -1;
        ASName key = sortItem.getName();
        PDFCollectionField field = this.mSchema.get(key);
        if (field == null) {
            return -direction;
        }
        PDFCollectionFieldType fieldType = field.getFieldType();
        if (fieldType.isInCollectionItem()) {
            PDFCollectionItem firstItem = first.getCollectionItem();
            PDFCollectionItem secondItem = second.getCollectionItem();
            if (firstItem == null) {
                if (secondItem == null) {
                    return 0;
                }
                return -1 * direction;
            }
            if (secondItem == null) {
                return 1 * direction;
            }
            if (firstItem.containsKey((Object)key) && !secondItem.containsKey((Object)key)) {
                return 1 * direction;
            }
            if (!firstItem.containsKey((Object)key) && secondItem.containsKey((Object)key)) {
                return -1 * direction;
            }
            if (!firstItem.containsKey((Object)key) && !secondItem.containsKey((Object)key)) {
                return 0;
            }
            if (fieldType.equal(PDFCollectionFieldType.date)) {
                compared = PDFCollectionItemComparator.compareDates(firstItem.getItemData(key).getDate(), secondItem.getItemData(key).getDate());
            } else if (fieldType.equal(PDFCollectionFieldType.number)) {
                compared = PDFCollectionItemComparator.compareNumbers(firstItem.getItemData(key).getNumber(), secondItem.getItemData(key).getNumber());
            } else if (fieldType.equal(PDFCollectionFieldType.text)) {
                String firstText = firstItem.getItemData(key).getText();
                String secondText = secondItem.getItemData(key).getText();
                compared = PDFCollectionItemComparator.compareText(firstText, secondText, this.mCollator);
            }
        } else if (fieldType.isInFileSpec()) {
            if (fieldType.equal(PDFCollectionFieldType.file)) {
                String text1 = first.getName();
                String text2 = second.getName();
                if (text1 != null && text2 != null) {
                    compared = PDFCollectionItemComparator.compareText(text1, text2, null);
                }
            } else if (fieldType.equal(PDFCollectionFieldType.Desc)) {
                String desc1 = first.getDescription();
                String desc2 = second.getDescription();
                compared = PDFCollectionItemComparator.compareText(desc1, desc2, null);
            }
        } else if (fieldType.isInEmbeddedFile()) {
            if (fieldType.equal(PDFCollectionFieldType.CreationDate)) {
                compared = PDFCollectionItemComparator.compareDates(first.getCreationDate(), second.getCreationDate());
            } else if (fieldType.equal(PDFCollectionFieldType.ModDate)) {
                compared = PDFCollectionItemComparator.compareDates(first.getModificationDate(), second.getModificationDate());
            }
        }
        return compared * direction;
    }
}

