/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBead_First;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFThreadInfo;

public class PDFThread
extends PDFCosDictionary {
    private PDFThread(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFThread newInstance(PDFDocument pdfDocument, PDFBead_First key_F) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_F == null) {
            throw new PDFInvalidParameterException("F is required when creating newInstance of PDFThread.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFThread pdfObject = new PDFThread(cosObject);
        pdfObject.setF(key_F);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_Thread);
        return pdfObject;
    }

    public static PDFThread getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFThread pdfObject = (PDFThread)PDFCosObject.getCachedInstance(cosObject, PDFThread.class);
        if (pdfObject == null) {
            pdfObject = new PDFThread(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFThreadInfo getI() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFThreadInfo.getInstance(this.getDictionaryCosObjectValue(ASName.k_I));
    }

    public void setI(PDFThreadInfo value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_I);
        } else {
            this.setDictionaryValue(ASName.k_I, value);
        }
    }

    public boolean hasI() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_I);
    }

    public PDFBead_First getF() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBead_First.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public void setF(PDFBead_First value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_F, value);
    }

    public PDFBead_First requireF() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBead_First pdfObject = PDFBead_First.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
        if (pdfObject == null) {
            throw new PDFInvalidDocumentException("Could not get F");
        }
        return pdfObject;
    }

    public boolean hasF() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }
}

