/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFThread;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class PDFBead
extends PDFCosDictionary {
    private static ASName k_Bead = ASName.create("Bead");

    protected PDFBead(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    protected PDFBead(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDoc));
        this.setDictionaryNameValue(ASName.k_Type, k_Bead);
    }

    public static PDFBead newInstance(PDFDocument pdfDocument, PDFRectangle key_Rectangle, PDFBead key_Next, PDFPage key_Page, PDFBead key_Previous) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Rectangle == null) {
            throw new PDFInvalidParameterException("Rectangle is required when creating newInstance of PDFBead.");
        }
        if (key_Next == null) {
            throw new PDFInvalidParameterException("Next is required when creating newInstance of PDFBead.");
        }
        if (key_Page == null) {
            throw new PDFInvalidParameterException("Page is required when creating newInstance of PDFBead.");
        }
        if (key_Previous == null) {
            throw new PDFInvalidParameterException("Previous is required when creating newInstance of PDFBead.");
        }
        PDFBead pdfObject = new PDFBead(pdfDocument);
        pdfObject.setRect(key_Rectangle);
        pdfObject.setNext(key_Next);
        pdfObject.setPage(key_Page);
        pdfObject.setPrevious(key_Previous);
        return pdfObject;
    }

    public static PDFBead getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFBead pdfObject = (PDFBead)PDFCosObject.getCachedInstance(cosObject, PDFBead.class);
        if (pdfObject == null) {
            pdfObject = new PDFBead(cosObject);
        }
        return pdfObject;
    }

    public PDFBead getPrevious() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBead.getInstance(this.getDictionaryCosObjectValue(ASName.k_V));
    }

    public void setPrevious(PDFBead value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Previous is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_V, value);
    }

    public PDFBead requirePrevious() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBead pdfObject = PDFBead.getInstance(this.getDictionaryCosObjectValue(ASName.k_V));
        if (pdfObject == null) {
            throw new PDFInvalidDocumentException("Could not get Previous");
        }
        return pdfObject;
    }

    public boolean hasPrevious() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_V);
    }

    public PDFBead getNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBead.getInstance(this.getDictionaryCosObjectValue(ASName.k_N));
    }

    public void setNext(PDFBead value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Next is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_N, value);
    }

    public PDFBead requireNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBead pdfObject = PDFBead.getInstance(this.getDictionaryCosObjectValue(ASName.k_N));
        if (pdfObject == null) {
            throw new PDFInvalidDocumentException("Could not get Next");
        }
        return pdfObject;
    }

    public boolean hasNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_N);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFRectangle getRect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.getInstance(this.getDictionaryValue(ASName.k_R));
    }

    public void setRect(PDFRectangle value) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidParameterException("Rectangle is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_R, value);
    }

    public boolean hasRectangle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_R);
    }

    public PDFThread getThread() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFThread.getInstance(this.getDictionaryCosObjectValue(ASName.k_T));
    }

    public void setThread(PDFThread value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_T, value);
    }

    public boolean hasThread() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_T);
    }

    public PDFPage getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPage.getInstance(this.getDictionaryCosObjectValue(ASName.k_P));
    }

    public void setPage(PDFPage value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Page is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_P, value);
    }

    public PDFPage requirePage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPage pdfObject = PDFPage.getInstance(this.getDictionaryCosObjectValue(ASName.k_P));
        if (pdfObject == null) {
            throw new PDFInvalidDocumentException("Could not get Page");
        }
        return pdfObject;
    }

    public boolean hasPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_P);
    }
}

