/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;

public class PDFMCPropertyMap
extends PDFCosDictionaryMap<PDFMCProperty> {
    private PDFMCPropertyMap(CosObject cosDict) throws PDFInvalidDocumentException {
        super(cosDict);
    }

    public static PDFMCPropertyMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMCPropertyMap pdfObject = (PDFMCPropertyMap)PDFCosObject.getCachedInstance(cosObject, PDFMCPropertyMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFMCPropertyMap(cosObject);
        }
        return pdfObject;
    }

    public static PDFMCPropertyMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMCPropertyMap pdfObject = new PDFMCPropertyMap(cosObject);
        return pdfObject;
    }

    @Override
    protected PDFMCProperty itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        return PDFMCProperty.getInstance(cosObject);
    }

    public PDFMCProperty set(ASName key, PDFMCProperty property) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFMCProperty prevProperty = this.get(key);
        this.getCosDictionary().put(key, property.getCosObject());
        return prevProperty;
    }

    public PDFMCProperty get(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (super.containsKey(name)) {
            return (PDFMCProperty)super.get(name);
        }
        return null;
    }
}

