/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAPacket;
import java.io.InputStream;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class PDFXFAArray
extends PDFCosObject {
    public static final ASString PREAMBLE = new ASString("xdp");
    public static final ASString POSTAMBLE = new ASString("/xdp");
    public static final ASString TEMPLATE = new ASString("template");
    public static final ASString DATASETS = new ASString("datasets");
    public static final ASString CONFIG = new ASString("config");

    private PDFXFAArray(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
        if (!(cosObject instanceof CosArray)) {
            throw new PDFInvalidDocumentException("Cos Array expected for XFA Array");
        }
    }

    public static PDFXFAArray getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFXFAArray pdfObject = (PDFXFAArray)PDFCosObject.getCachedInstance(cosObject, PDFXFAArray.class);
        if (pdfObject == null) {
            pdfObject = new PDFXFAArray(cosObject);
        }
        return pdfObject;
    }

    public static PDFXFAArray newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFXFAArray pdfObject = new PDFXFAArray(cosObject);
        return pdfObject;
    }

    public int getNumPackets() {
        return this.getCosArray().size() / 2;
    }

    public int find(ASString packet) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        for (int i = 0; i < this.getNumPackets(); ++i) {
            if (!packet.equals(this.getPacketName(i))) continue;
            return i;
        }
        return -1;
    }

    public ASString getPacketName(int packetNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosArray().getString(packetNumber * 2);
    }

    public PDFStream getStream(ASString packetName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int packetNumber = this.find(packetName);
        if (packetNumber < 0) {
            return null;
        }
        return PDFStream.getInstance(this.getCosArray().get(packetNumber * 2 + 1));
    }

    public PDFStream getStream(int packetNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStream.getInstance(this.getCosArray().get(packetNumber * 2 + 1));
    }

    public boolean update(int packetNumber, ByteReader data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStream stream = this.getStream(packetNumber);
        stream.setStreamData(data);
        return true;
    }

    public boolean update(ASString packetName, ByteReader data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int packetNumber = this.find(packetName);
        if (packetNumber < 0) {
            return false;
        }
        PDFStream stream = this.getStream(packetNumber);
        stream.setStreamData(data);
        return true;
    }

    public boolean update(int packetNumber, InputStream data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStream stream = this.getStream(packetNumber);
        stream.setStreamData(data);
        return true;
    }

    public boolean update(ASString packetName, InputStream data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int packetNumber = this.find(packetName);
        if (packetNumber < 0) {
            return false;
        }
        PDFStream stream = this.getStream(packetNumber);
        stream.setStreamData(data);
        return true;
    }

    public void insert(int packetNumber, ASString packet, PDFStream stream) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.getCosArray().addString(packetNumber * 2, packet);
        this.getCosArray().add(packetNumber * 2 + 1, stream.getCosObject());
    }

    public void insert(ASString packet, PDFStream stream) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        int packetNumber = this.getNumPackets();
        if (packetNumber >= 2) {
            --packetNumber;
        }
        this.insert(packetNumber, packet, stream);
    }

    public boolean insert(ASString after, ASString packet, PDFStream stream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int packetNumber = this.find(after);
        if (packetNumber < 0) {
            return false;
        }
        this.insert(packetNumber + 1, packet, stream);
        return true;
    }

    public void removePacket(int packetNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosArray().remove(packetNumber * 2);
        this.getCosArray().remove(packetNumber * 2);
    }

    public boolean removePacket(ASString packetName) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        int packetNumber = this.find(packetName);
        if (packetNumber < 0) {
            return false;
        }
        this.removePacket(packetNumber);
        return true;
    }

    public void clear() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosArray().clear();
    }

    public Iterator<PDFXFAPacket> iterator() {
        return new PDFXFAArrayIterator();
    }

    public class PDFXFAArrayIterator
    implements Iterator<PDFXFAPacket> {
        private final ListIterator<CosObject> mIterator;

        public PDFXFAArrayIterator() {
            this.mIterator = PDFXFAArray.this.getCosArray().listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public PDFXFAPacket next() {
            CosObject packetName = this.mIterator.next();
            CosObject dataStream = this.mIterator.next();
            if (packetName instanceof CosString && dataStream instanceof CosStream) {
                try {
                    return new PDFXFAPacket(packetName.stringValue(), PDFStream.getInstance(dataStream));
                }
                catch (PDFException e) {
                    NoSuchElementException newException = new NoSuchElementException("Error getting next packet from PDFXFAArray");
                    newException.initCause(e);
                    throw newException;
                }
            }
            throw new NoSuchElementException("Invalid data present in PDFXFAArray");
        }

        @Override
        public void remove() {
            this.mIterator.remove();
            this.mIterator.previous();
            this.mIterator.remove();
        }
    }
}

