/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;

public class PDFNamedJavaScripts
extends PDFNameTree<PDFActionJavaScript> {
    private PDFNamedJavaScripts(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFNamedJavaScripts getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFNamedJavaScripts pdfObject = (PDFNamedJavaScripts)PDFCosObject.getCachedInstance(cosObject, PDFNamedJavaScripts.class);
        if (pdfObject == null) {
            pdfObject = new PDFNamedJavaScripts(cosObject);
        }
        return pdfObject;
    }

    public static PDFNamedJavaScripts newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFNamedJavaScripts(cosObject);
    }

    @Override
    protected PDFActionJavaScript makeValueType(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return PDFActionJavaScript.getInstance(cosObject);
    }

    @Override
    protected CosObject getCosObjectFromValue(PDFActionJavaScript value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value.getCosObject();
    }
}

