/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAArray;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAStream;

public class PDFInteractiveForm
extends PDFFieldNode {
    private static final ASName k_SigFlags = ASName.create("SigFlags");
    public static final int SignatureExists = 1;
    public static final int AppendOnly = 2;

    private PDFInteractiveForm(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFInteractiveForm getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFInteractiveForm pdfObject = (PDFInteractiveForm)PDFCosObject.getCachedInstance(cosObject, PDFInteractiveForm.class);
        if (pdfObject == null) {
            pdfObject = new PDFInteractiveForm(cosObject);
        }
        return pdfObject;
    }

    public static PDFInteractiveForm newInstance(PDFDocument pdfDocument, PDFFieldList pdfFields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFInteractiveForm pdfIForm = new PDFInteractiveForm(cosObject);
        pdfIForm.setChildren(pdfFields);
        return pdfIForm;
    }

    @Override
    public PDFFieldList getChildren() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getChildren(false);
    }

    @Override
    public PDFFieldList getChildren(boolean useAcrobatIsTerminalCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldList.getInstance(this.getDictionaryCosObjectValue(ASName.k_Fields), useAcrobatIsTerminalCheck);
    }

    public PDFFieldList procureChildren() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldList fields = this.getChildren();
        if (fields == null) {
            fields = PDFFieldList.newInstance(this.getPDFDocument());
            this.setChildren(fields);
        }
        return fields;
    }

    public PDFFieldList getCalculationOrder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldList.getInstance(this.getDictionaryCosObjectValue(ASName.k_CO));
    }

    public void setCalculationOrder(PDFFieldList fields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (fields != null) {
            this.setDictionaryArrayValue(ASName.k_CO, fields.getCosArray());
        } else {
            this.removeValue(ASName.k_CO);
        }
    }

    public void setChildren(PDFFieldList fields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (fields != null) {
            this.setDictionaryArrayValue(ASName.k_Fields, fields.getCosArray());
        } else {
            this.setDictionaryArrayValue(ASName.k_Fields, this.getPDFDocument().getCosDocument().createCosArray());
        }
    }

    @Override
    public void addChild(PDFFieldNode childNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldList kids = this.getChildren();
        if (kids == null) {
            kids = PDFFieldList.newInstance(this.getPDFDocument());
            kids.add(childNode);
            this.setDictionaryArrayValue(ASName.k_Fields, kids.getCosArray());
        } else {
            kids.add(childNode);
        }
        childNode.setParent(this);
    }

    public void setNeedAppearances(boolean state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_NeedAppearances, state);
    }

    public boolean getNeedAppearances() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_NeedAppearances)) {
            return this.getDictionaryBooleanValue(ASName.k_NeedAppearances);
        }
        return false;
    }

    public void removeNeedAppearances() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().remove(ASName.k_NeedAppearances);
    }

    public boolean hasNeedAppearances() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_NeedAppearances);
    }

    public boolean hasXFA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_XFA);
    }

    public PDFXFAArray getXFAAsArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXFAArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_XFA));
    }

    public void setXFA(PDFXFAArray xfaArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xfaArray == null) {
            this.removeValue(ASName.k_XFA);
        } else {
            this.setDictionaryArrayValue(ASName.k_XFA, xfaArray.getCosArray());
        }
    }

    public void setXFA(PDFXFAStream xfaStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xfaStream == null) {
            this.removeValue(ASName.k_XFA);
        } else {
            this.setDictionaryStreamValue(ASName.k_XFA, xfaStream.getCosStream());
        }
    }

    public PDFXFAStream getXFAAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXFAStream.getInstance(this.getDictionaryCosObjectValue(ASName.k_XFA));
    }

    public boolean xfaIsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().get(ASName.k_XFA) instanceof CosStream;
    }

    public boolean xfaIsArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().get(ASName.k_XFA) instanceof CosArray;
    }

    public void removeXFA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().remove(ASName.k_XFA);
    }

    public int getDefaultQuadding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject quaddingValue = this.getDictionaryCosObjectValue(ASName.k_Q);
        if (quaddingValue == null) {
            return 0;
        }
        if (quaddingValue.getType() != 1) {
            return 0;
        }
        Number qadding = quaddingValue.numberValue();
        return qadding == null ? 0 : qadding.intValue();
    }

    public String getDefaultAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFText defaultAppearance = PDFText.getInstance(this.getDictionaryCosObjectValue(ASName.k_DA));
        return defaultAppearance == null ? null : defaultAppearance.stringValue();
    }

    public void setDefaultAppearance(byte[] appearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryByteArrayValue(ASName.k_DA, appearance);
    }

    public PDFResources getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFResources.getInstance(this.getDictionaryCosObjectValue(ASName.k_DR));
    }

    public PDFResources procureResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources resources = this.getResources();
        if (resources == null) {
            resources = PDFResources.newInstance(this.getPDFDocument());
            this.setResources(resources);
        }
        return resources;
    }

    public void setResources(PDFResources pdfResources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_DR, pdfResources);
    }

    public int getSigFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(k_SigFlags)) {
            return this.getDictionaryIntValue(k_SigFlags);
        }
        return 0;
    }

    public void setSigFlags(int sigFlags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_SigFlags, sigFlags);
    }

    public void removeSigFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(k_SigFlags);
    }

    public PDFFieldNode procureIntermediateFieldNodes(String qualifiedName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFFieldUtils.procureIntermediateFieldNodes(qualifiedName, false, this);
    }
}

