/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import java.util.ArrayList;
import java.util.List;

public abstract class PDFFieldWithOptions
extends PDFField {
    protected PDFFieldWithOptions(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public CosObject getOptionValue() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCosUtils.getInheritableValue(ASName.k_Opt, ASName.k_Parent, this);
    }

    public boolean hasOptionList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return super.getCosDictionary().get(ASName.k_Opt) != null;
    }

    public List getOptionList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject options = this.getOptionValue();
        if (options == null) {
            return null;
        }
        return this.addOptionsItem(null, options);
    }

    private List addOptionsItem(List optionList, CosObject cosItem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosItem.getType() == 4) {
            PDFText text = PDFText.getInstance(cosItem);
            if (optionList == null) {
                optionList = new ArrayList<String>();
            }
            optionList.add(text.stringValue());
        } else if (cosItem.getType() == 5) {
            CosArray cosArray = (CosArray)cosItem;
            ArrayList arrayVal = new ArrayList(2);
            for (int arrayInd = 0; arrayInd < cosArray.size(); ++arrayInd) {
                CosObject arrayItem = cosArray.get(arrayInd);
                this.addOptionsItem(arrayVal, arrayItem);
            }
            if (optionList == null) {
                optionList = arrayVal;
            } else {
                optionList.add((String)((Object)arrayVal));
            }
        }
        return optionList;
    }

    public void setOptionList(List option) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Opt, option);
    }

    public void setOptionList(String option) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Opt, option);
    }

    public void setOptionList(String option, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Opt, option, unicode);
    }
}

