/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocumentTimeStampSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureSubFilter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.impl.FieldAndAnnotationImpl;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PDFFieldUtils {
    private PDFFieldUtils() {
    }

    public static String createNewQualifiedName(PDFFieldNode rootNode, String qualifiedName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (qualifiedName.indexOf(46) == -1) {
            if (Character.isDigit(qualifiedName.charAt(qualifiedName.length() - 1))) {
                qualifiedName = qualifiedName.substring(0, qualifiedName.length() - 1);
            }
            return PDFFieldUtils.generateUniqueFieldName(rootNode, qualifiedName);
        }
        String baseFieldName = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
        StringBuilder newFieldName = new StringBuilder();
        newFieldName.append(qualifiedName.substring(0, qualifiedName.lastIndexOf(46) + 1));
        if (Character.isDigit(baseFieldName.charAt(baseFieldName.length() - 1))) {
            newFieldName.append(PDFFieldUtils.generateUniqueFieldName(rootNode, baseFieldName.substring(0, baseFieldName.length() - 1)));
        } else {
            newFieldName.append(PDFFieldUtils.generateUniqueFieldName(rootNode, baseFieldName));
        }
        return newFieldName.toString();
    }

    public static String generateUniqueFieldName(PDFFieldNode rootNode, String baseStr) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean done = false;
        String fieldName = null;
        int i = 1;
        do {
            if (PDFFieldUtils.fieldNameInUse(rootNode, fieldName = baseStr + i++)) continue;
            done = true;
        } while (!done);
        return fieldName;
    }

    static boolean fieldNameInUse(PDFFieldNode rootNode, String fieldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isAcrobatCompatible = false;
        Iterator<PDFField> fieldIterator = rootNode.iterator(isAcrobatCompatible);
        while (fieldIterator.hasNext()) {
            PDFFieldNode pdfFieldNode = fieldIterator.next();
            String curFieldName = pdfFieldNode.getInheritedPartialName();
            if (curFieldName == null || !curFieldName.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    static String getTerminalFieldName(String fullyQualifiedFieldName) {
        String[] partialNames = fullyQualifiedFieldName != null ? fullyQualifiedFieldName.split("\\.") : new String[]{};
        int terminalFieldNameIndex = -1;
        for (int i = 0; i < partialNames.length; ++i) {
            if (partialNames[i] == null || partialNames[i].equals("")) continue;
            terminalFieldNameIndex = i;
        }
        return terminalFieldNameIndex > -1 ? partialNames[terminalFieldNameIndex] : null;
    }

    static boolean isTerminalField(CosDictionary fieldDict, boolean useAcrobatIsTerminalFieldCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = fieldDict.get(ASName.k_Kids);
        if (cosObject == null || cosObject instanceof CosNull) {
            return true;
        }
        CosArray kidsArray = null;
        if (!(cosObject instanceof CosArray)) {
            throw new PDFInvalidDocumentException(cosObject.getObjNum() + " should be a CosArray.");
        }
        kidsArray = (CosArray)cosObject;
        CosDictionary cosKid = null;
        for (int i = 0; i < kidsArray.size(); ++i) {
            cosObject = kidsArray.get(i);
            if (!(cosObject instanceof CosDictionary)) continue;
            cosKid = (CosDictionary)cosObject;
            break;
        }
        if (cosKid == null) {
            return true;
        }
        if (!useAcrobatIsTerminalFieldCheck) {
            if (cosKid.containsKey(ASName.k_Subtype) && !cosKid.containsKey(ASName.k_FT) && !cosKid.containsKey(ASName.k_Parent)) {
                return true;
            }
        } else {
            if (!(cosKid.containsKey(ASName.k_T) && cosKid.get(ASName.k_T).getType() == 4 || cosKid.getName(ASName.k_Subtype) != ASName.k_Widget)) {
                return true;
            }
            if (fieldDict.getName(ASName.k_Subtype) == ASName.k_Widget) {
                return true;
            }
        }
        return false;
    }

    public static boolean isFieldNode(PDFDocument srcDoc, CosDictionary cosObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm acroForm = srcDoc.getInteractiveForm();
        if (acroForm == null) {
            return false;
        }
        PDFFieldList acroFields = acroForm.getChildren();
        if (acroFields == null) {
            return false;
        }
        CosDictionary curObj = cosObj;
        CosDictionary parent = null;
        while (curObj != null) {
            parent = curObj;
            curObj = cosObj.getCosDictionary(ASName.k_Parent);
        }
        PDFFieldNode topField = PDFFieldNode.getInstance(parent);
        return topField != null && acroForm.getChildren().contains(topField);
    }

    public static boolean containsPureFieldKeys(PDFAnnotation annotation) {
        List<ASName> keySet = annotation.getCosDictionary().getKeys();
        for (ASName key : keySet) {
            if (!Utility.nameInArray(key, PDFFieldNode.pureFieldKeys)) continue;
            return true;
        }
        return false;
    }

    public static String[] getFullyQualifiedFieldNames(PDFFieldNode rootNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<String> fullNames = new ArrayList<String>();
        boolean isAcrobatCompatible = false;
        Iterator<PDFField> fieldIterator = rootNode.iterator(isAcrobatCompatible);
        while (fieldIterator.hasNext()) {
            PDFField pdfField = fieldIterator.next();
            String fieldFullName = pdfField.getQualifiedName();
            if (fieldFullName == null) continue;
            fullNames.add(fieldFullName);
        }
        return fullNames.toArray(new String[fullNames.size()]);
    }

    public static boolean qualifiedNamesConflict(String[] newNames, String[] inUseNames) {
        for (int i = 0; i < newNames.length; ++i) {
            String name = newNames[i];
            for (int j = 0; j < inUseNames.length; ++j) {
                if (!name.equals(inUseNames[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean partialNameConflicts(String partialName, PDFFieldNode fieldNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String parentFullName;
        PDFFieldNode parent = fieldNode.getParent();
        String newFullNameForThisNode = parent == null || parent instanceof PDFInteractiveForm ? (partialName == null ? "" : partialName) : ((parentFullName = parent.getQualifiedName()) != null ? parentFullName + (partialName == null ? "" : "." + partialName) : (partialName == null ? "" : partialName));
        String thisNodeFullName = fieldNode.getQualifiedName();
        int thisNodeFullNameLength = thisNodeFullName != null ? thisNodeFullName.length() : 0;
        String[] nodeFullFieldNames = PDFFieldUtils.getFullyQualifiedFieldNames(fieldNode);
        if (nodeFullFieldNames.length > 0) {
            for (int i = 0; i < nodeFullFieldNames.length; ++i) {
                String name = nodeFullFieldNames[i].substring(thisNodeFullNameLength);
                nodeFullFieldNames[i] = newFullNameForThisNode + name;
            }
        } else {
            nodeFullFieldNames = new String[]{newFullNameForThisNode};
        }
        PDFInteractiveForm iform = fieldNode.getPDFDocument().requireCatalog().procureInteractiveForm();
        String[] allFullFieldNames = PDFFieldUtils.getFullyQualifiedFieldNames(iform);
        return PDFFieldUtils.qualifiedNamesConflict(nodeFullFieldNames, allFullFieldNames);
    }

    public static String generateUniquePartialName(String partialName, PDFFieldNode fieldNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (partialName != null && (partialName.length() == 0 || partialName.indexOf(46) >= 0)) {
            throw new PDFInvalidParameterException("The partial name supplied is not valid. It either is an empty string or contains a \".\"");
        }
        String currentPartialName = fieldNode.getPartialName();
        if (currentPartialName == null && partialName == null) {
            return partialName;
        }
        if (currentPartialName != null && currentPartialName.equals(partialName)) {
            return partialName;
        }
        if (PDFFieldUtils.partialNameConflicts(partialName, fieldNode)) {
            return PDFFieldUtils.generateUniqueFieldName(fieldNode.getParent(), partialName);
        }
        return partialName;
    }

    public static boolean isPartialNameAllowed(String partialName, PDFFieldNode fieldNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (partialName != null && (partialName.length() == 0 || partialName.indexOf(46) >= 0)) {
            return false;
        }
        String currentPartialName = fieldNode.getPartialName();
        if (currentPartialName == null && partialName == null) {
            return true;
        }
        if (currentPartialName != null && currentPartialName.equals(partialName)) {
            return true;
        }
        return !PDFFieldUtils.partialNameConflicts(partialName, fieldNode);
    }

    public static PDFAnnotationWidget separateFieldAnnot(PDFField field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!field.isAnnotation()) {
            return null;
        }
        PDFAnnotationWidget fieldAnnot = PDFAnnotationWidget.getInstance(field.getCosObject());
        PDFPage page = fieldAnnot.getPage();
        PDFAnnotationList annots = page.getAnnotationList();
        annots.remove(fieldAnnot);
        PDFAnnotationWidget newWidget = PDFAnnotationWidget.newInstance(page, fieldAnnot.getRect());
        CosDictionary newDict = newWidget.getCosDictionary();
        CosDictionary thisDict = field.getCosDictionary();
        Set<ASName> keys = thisDict.keySet();
        Iterator<ASName> iter = keys.iterator();
        while (iter.hasNext()) {
            ASName key = iter.next();
            if (!PDFAnnotationWidget.widgetAnnotKeys.contains(key)) continue;
            newDict.put(key, thisDict.get(key));
            iter.remove();
        }
        field.addAnnotation(newWidget);
        newWidget.setParentField(field);
        return newWidget;
    }

    static PDFAnnotationWidget getFirstAnnot(PDFFieldNode currentNode, boolean useAcrobatIsTerminalFieldCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<PDFField> nodeIter = currentNode.iterator(useAcrobatIsTerminalFieldCheck);
        PDFFieldNode node = null;
        if (nodeIter.hasNext()) {
            node = nodeIter.next();
            return PDFAnnotationWidget.getInstance(node.getCosObject());
        }
        PDFFieldNode firstChild = (PDFFieldNode)currentNode.getChildren(useAcrobatIsTerminalFieldCheck).get(0);
        return PDFAnnotationWidget.getInstance(firstChild.getCosObject());
    }

    public static FieldAndAnnotationImpl findChildFieldNode(String[] partialNames, PDFFieldNode parentNode, PDFFieldNode currentNode, boolean useAcrobatIsTerminalFieldCheck, int indexOfNextPartialNameToMatch) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldList kids = currentNode.getChildren(useAcrobatIsTerminalFieldCheck);
        if (kids == null) {
            return null;
        }
        Iterator<PDFFieldNode> kidsIter = kids.iterator(useAcrobatIsTerminalFieldCheck);
        int nodeIndex = 0;
        while (kidsIter.hasNext()) {
            FieldAndAnnotationImpl descendentNode;
            PDFFieldNode node = kidsIter.next();
            if (node.getPartialName() != null) {
                if (node.getPartialName().equals(partialNames[indexOfNextPartialNameToMatch])) {
                    if (indexOfNextPartialNameToMatch == partialNames.length - 1) {
                        FieldAndAnnotationImpl nodeAndAnnotImpl;
                        if (node.isTerminalField()) {
                            nodeAndAnnotImpl = new FieldAndAnnotationImpl();
                            nodeAndAnnotImpl.setNode(node);
                            PDFAnnotationWidget annot = PDFAnnotationWidget.getInstance(node.getCosObject());
                            nodeAndAnnotImpl.setAnnot(annot);
                            return nodeAndAnnotImpl;
                        }
                        nodeAndAnnotImpl = new FieldAndAnnotationImpl();
                        nodeAndAnnotImpl.setNode(node);
                        PDFAnnotationWidget firstAnnot = PDFFieldUtils.getFirstAnnot(node, useAcrobatIsTerminalFieldCheck);
                        nodeAndAnnotImpl.setAnnot(firstAnnot);
                        return nodeAndAnnotImpl;
                    }
                    if ((descendentNode = PDFFieldUtils.findChildFieldNode(partialNames, currentNode, node, useAcrobatIsTerminalFieldCheck, ++indexOfNextPartialNameToMatch)) != null) {
                        return descendentNode;
                    }
                }
            } else if (PDFFieldUtils.isTerminalField(node.getCosDictionary(), useAcrobatIsTerminalFieldCheck)) {
                String nodeImplicitPartialName = String.valueOf(nodeIndex);
                if (nodeImplicitPartialName.equals(partialNames[indexOfNextPartialNameToMatch])) {
                    if (indexOfNextPartialNameToMatch != partialNames.length - 1) {
                        return null;
                    }
                    PDFAnnotationWidget annot = PDFAnnotationWidget.getInstance(node.getCosObject());
                    FieldAndAnnotationImpl nodeAndAnnotImpl = new FieldAndAnnotationImpl();
                    nodeAndAnnotImpl.setNode(node);
                    nodeAndAnnotImpl.setAnnot(annot);
                    return nodeAndAnnotImpl;
                }
            } else {
                descendentNode = PDFFieldUtils.findChildFieldNode(partialNames, currentNode, node, useAcrobatIsTerminalFieldCheck, indexOfNextPartialNameToMatch);
                if (descendentNode != null) {
                    return descendentNode;
                }
            }
            ++nodeIndex;
        }
        return null;
    }

    public static PDFFieldNode findChildFieldNode(String qualifiedName, PDFFieldNode currentNode, boolean useAcrobatIsTerminalFieldCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldList kids = currentNode.getChildren(useAcrobatIsTerminalFieldCheck);
        if (kids == null) {
            return null;
        }
        Iterator<PDFFieldNode> iter = kids.iterator(useAcrobatIsTerminalFieldCheck);
        while (iter.hasNext()) {
            PDFFieldNode node = iter.next();
            if (node == null) continue;
            if (node.getPartialName() != null) {
                if (!node.getQualifiedName().equals(qualifiedName)) continue;
                return node;
            }
            PDFFieldNode descendentNode = PDFFieldUtils.findChildFieldNode(qualifiedName, node, useAcrobatIsTerminalFieldCheck);
            if (descendentNode == null) continue;
            return descendentNode;
        }
        return null;
    }

    public static PDFFieldNode getFieldNode(String qualifiedName, PDFInteractiveForm iForm, boolean useAcrobatIsTerminalFieldCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] partialNames = qualifiedName.split("\\.");
        String currentName = "";
        PDFFieldNode node = iForm;
        for (int i = 0; i < partialNames.length; ++i) {
            node = PDFFieldUtils.findChildFieldNode(currentName = currentName.length() == 0 ? currentName + partialNames[i] : currentName + "." + partialNames[i], node, useAcrobatIsTerminalFieldCheck);
            if (node != null) continue;
            return null;
        }
        return node;
    }

    public static PDFFieldNode procureIntermediateFieldNodes(String qualifiedName, boolean useUnicodeEncoding, PDFFieldNode fieldNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (qualifiedName == null) {
            return fieldNode;
        }
        if ("".equals(qualifiedName)) {
            return fieldNode;
        }
        String[] partialNames = qualifiedName.split("\\.");
        int terminalFieldNameIndex = 0;
        for (int i = 0; i < partialNames.length; ++i) {
            if (partialNames[i] == null || partialNames[i].equals("")) continue;
            terminalFieldNameIndex = i;
        }
        PDFFieldNode currentNode = fieldNode;
        StringBuilder fieldNodeQualifiedName = null;
        for (int i = 0; i < terminalFieldNameIndex; ++i) {
            if (partialNames[i] == null || partialNames[i].equals("")) continue;
            if (fieldNodeQualifiedName == null) {
                fieldNodeQualifiedName = new StringBuilder(partialNames[i]);
            } else {
                fieldNodeQualifiedName.append('.');
                fieldNodeQualifiedName.append(partialNames[i]);
            }
            PDFFieldNode childNode = PDFFieldUtils.findChildFieldNode(fieldNodeQualifiedName.toString(), currentNode, false);
            if (childNode != null) {
                if (childNode.isTerminalField()) {
                    throw new PDFInvalidParameterException("Cannot procure intermediate field nodes because the specified qualified name is in use by a terminal field.");
                }
                currentNode = childNode;
                continue;
            }
            while (i < terminalFieldNameIndex) {
                childNode = PDFFieldNode.newInstance(fieldNode.getPDFDocument());
                currentNode.addChild(childNode);
                if (!(currentNode instanceof PDFInteractiveForm)) {
                    childNode.setParent(currentNode);
                }
                childNode.setPartialName(partialNames[i], useUnicodeEncoding);
                currentNode = childNode;
                ++i;
            }
        }
        return currentNode;
    }

    public static PDFFieldNode[] searchFields(String[] fieldNames, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm acroForm = pdfDoc.getInteractiveForm();
        HashMap<PDFFieldNode, AbstractSet> fieldToChildNamesMap = new HashMap<PDFFieldNode, AbstractSet>();
        HashSet<PDFFieldNode> fieldNodes = new HashSet<PDFFieldNode>();
        TreeSet<String> sortedFieldNamesSet = new TreeSet<String>();
        for (int i = 0; i < fieldNames.length; ++i) {
            sortedFieldNamesSet.add(fieldNames[i]);
        }
        fieldToChildNamesMap.put(acroForm, sortedFieldNamesSet);
        Iterator itrEntry = fieldToChildNamesMap.entrySet().iterator();
        String[] childNames = null;
        while (itrEntry.hasNext()) {
            Map.Entry entry = itrEntry.next();
            PDFFieldNode keyFieldNode = (PDFFieldNode)entry.getKey();
            childNames = ((Set)entry.getValue()).toArray(new String[0]);
            int i = 0;
            while (i < childNames.length) {
                String[] subStrings = childNames[i].split("\\.", 2);
                String partialName = subStrings[0];
                PDFFieldList childrenList = keyFieldNode.getChildren();
                if (childrenList == null || childrenList.size() == 0) {
                    ++i;
                    continue;
                }
                PDFFieldNode node = childrenList.getFieldNamed(partialName);
                HashSet<String> childNamesSet = new HashSet<String>();
                while (subStrings[0].equals(partialName)) {
                    if (subStrings.length == 2) {
                        childNamesSet.add(subStrings[1]);
                    } else if (node != null) {
                        fieldNodes.add(node);
                    }
                    if (++i >= childNames.length) break;
                    subStrings = childNames[i].split("\\.", 2);
                }
                if (node == null) continue;
                if (fieldToChildNamesMap.containsKey(node)) {
                    Set presentList = (Set)fieldToChildNamesMap.get(node);
                    childNamesSet.addAll(presentList);
                }
                fieldToChildNamesMap.put(node, childNamesSet);
            }
            fieldToChildNamesMap.remove(keyFieldNode);
            itrEntry = fieldToChildNamesMap.entrySet().iterator();
        }
        int size = fieldNodes.size();
        return size > 0 ? fieldNodes.toArray(new PDFFieldNode[size]) : null;
    }

    public static PDFRectangle transformSignatureFieldAnnot(PDFPage page, PDFRectangle annotRect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRotation rotation = page.getRotation();
        double pageWidth = page.getArtBox().width();
        double pageHeight = page.getArtBox().height();
        ASMatrix translateMatrix = null;
        ASRectangle asRect = null;
        if (rotation == PDFRotation.ROTATE_0) {
            return annotRect;
        }
        if (rotation == PDFRotation.ROTATE_90) {
            translateMatrix = ASMatrix.createIdentityMatrix().translate(0.0, -pageWidth);
        } else if (rotation == PDFRotation.ROTATE_180) {
            translateMatrix = ASMatrix.createIdentityMatrix().translate(-pageWidth, -pageHeight);
        } else if (rotation == PDFRotation.ROTATE_270) {
            translateMatrix = ASMatrix.createIdentityMatrix().translate(-pageHeight, 0.0);
        }
        ASMatrix rotateMatrix = ASMatrix.createIdentityMatrix().rotate(Math.toRadians(rotation.getValue()));
        ASMatrix finalTransformMatrix = translateMatrix.concat(rotateMatrix);
        asRect = annotRect.getRectangle().transform(finalTransformMatrix);
        return PDFRectangle.newInstance(page.getPDFDocument(), asRect).normalized(page.getPDFDocument());
    }

    public static void removeAnnotation(PDFAnnotation targetAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationList annots;
        PDFPage page = targetAnnot.getPage();
        if (page != null && (annots = page.getAnnotationList()).remove(targetAnnot) && annots.isEmpty()) {
            page.removeAnnotationList();
        }
    }

    public static int getSelectedIndexForChoiceField(String selItem, List options, String fieldName) throws PDFInvalidDocumentException {
        int idx;
        if (selItem.trim().equals("")) {
            return -1;
        }
        String option = null;
        if (options == null) {
            throw new PDFInvalidDocumentException("Item " + selItem + " cannot be found in the choice field" + fieldName + ". Option list for the field is null.");
        }
        for (idx = 0; idx < options.size(); ++idx) {
            option = PDFFieldUtils.getValueFromOptions(options.get(idx), fieldName);
            if (!option.equals(selItem)) continue;
            return idx;
        }
        for (idx = 0; idx < options.size(); ++idx) {
            option = PDFFieldUtils.getValueFromOptionsHandleAcrobatBug(options.get(idx), fieldName);
            if (!option.equals(selItem)) continue;
            return idx;
        }
        throw new PDFInvalidDocumentException("Item " + selItem + " cannot be found in the choice field" + fieldName + ".");
    }

    static String getNameFromOptionsHandleAcrobatBug(Object option, String fieldName) throws PDFInvalidDocumentException {
        String optionName = null;
        if (option instanceof String) {
            optionName = (String)option;
        }
        if (option instanceof ArrayList && option != null && ((ArrayList)option).size() > 0) {
            if (((ArrayList)option).size() > 2) {
                throw new PDFInvalidDocumentException("More than 2 elements in Opt array for choice field " + fieldName + ".");
            }
            if (((ArrayList)option).size() == 1) {
                optionName = (String)((ArrayList)option).get(0);
            }
            if (((ArrayList)option).size() == 2) {
                optionName = (String)((ArrayList)option).get(0);
            }
        }
        return optionName;
    }

    public static String getSelectedNameForChoiceField(String selItem, List options, String fieldName) throws PDFInvalidDocumentException {
        int idx;
        if (selItem.trim().equals("")) {
            return null;
        }
        String option = null;
        for (idx = 0; idx < options.size(); ++idx) {
            option = PDFFieldUtils.getNameFromOptions(options.get(idx), fieldName);
            if (!option.equals(selItem)) continue;
            return PDFFieldUtils.getValueFromOptions(options.get(idx), fieldName);
        }
        for (idx = 0; idx < options.size(); ++idx) {
            option = PDFFieldUtils.getNameFromOptionsHandleAcrobatBug(options.get(idx), fieldName);
            if (!option.equals(selItem)) continue;
            return PDFFieldUtils.getValueFromOptions(options.get(idx), fieldName);
        }
        throw new PDFInvalidDocumentException("Item " + selItem + " cannot be found in the choice field" + fieldName + ".");
    }

    public static String getValueFromOptions(Object value, String fieldName) throws PDFInvalidDocumentException {
        String optionValue = null;
        if (value instanceof String) {
            optionValue = (String)value;
        }
        if (value instanceof ArrayList && value != null && ((ArrayList)value).size() > 0) {
            if (((ArrayList)value).size() > 2) {
                throw new PDFInvalidDocumentException("More than 2 elements in Opt array for choice field " + fieldName + ".");
            }
            optionValue = ((ArrayList)value).size() == 1 ? (String)((ArrayList)value).get(0) : (String)((ArrayList)value).get(1);
        }
        return optionValue;
    }

    public static String getValueFromOptionsHandleAcrobatBug(Object value, String fieldName) throws PDFInvalidDocumentException {
        String optionValue = null;
        if (value instanceof String) {
            optionValue = (String)value;
        }
        if (value instanceof ArrayList && value != null && ((ArrayList)value).size() > 0) {
            if (((ArrayList)value).size() > 2) {
                throw new PDFInvalidDocumentException("More than 2 elements in Opt array for choice field " + fieldName + ".");
            }
            optionValue = (String)((ArrayList)value).get(0);
        }
        return optionValue;
    }

    public static String getNameFromOptions(Object option, String fieldName) throws PDFInvalidDocumentException {
        String optionName = null;
        if (option instanceof String) {
            optionName = (String)option;
        }
        if (option instanceof ArrayList && option != null && ((ArrayList)option).size() > 0) {
            if (((ArrayList)option).size() > 2) {
                throw new PDFInvalidDocumentException("More than 2 elements in Opt array for choice field " + fieldName + ".");
            }
            if (((ArrayList)option).size() == 1) {
                optionName = (String)((ArrayList)option).get(0);
            }
            if (((ArrayList)option).size() == 2) {
                optionName = (String)((ArrayList)option).get(1);
            }
        }
        return optionName;
    }

    public static PDFSignature getSignature(CosDictionary signatureDict) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        ASName subFilter = signatureDict.getName(ASName.k_SubFilter);
        if (subFilter != null && subFilter.asString(true).equals(PDFSignatureSubFilter.ETSIRFC3161.getValue())) {
            return PDFDocumentTimeStampSignature.getInstance(signatureDict);
        }
        return PDFSignature.getInstance(signatureDict);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeField(PDFField field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm iform = field.getPDFDocument().getInteractiveForm();
        PDFFieldNode parentNode = field.getParent();
        if (parentNode == null) {
            if (!iform.getChildren().contains(field)) throw new PDFInvalidDocumentException("Field does not contain Parent entry");
            iform.getChildren().remove(field);
        } else {
            PDFFieldList parentNodeChildList = parentNode.getChildren();
            parentNodeChildList.remove(field);
            HashSet<PDFFieldNode> visitedNodes = new HashSet<PDFFieldNode>();
            while (parentNodeChildList.isEmpty() && !visitedNodes.contains(parentNode)) {
                visitedNodes.add(parentNode);
                PDFFieldNode currParentNode = parentNode.getParent();
                if (currParentNode == null) {
                    iform.getChildren().remove(parentNode);
                    break;
                }
                parentNodeChildList = currParentNode.getChildren();
                parentNodeChildList.remove(parentNode);
                parentNode = currParentNode;
            }
        }
        PDFAnnotationIterator annotIter = field.getAnnotationsIterator();
        while (annotIter.hasNext()) {
            PDFAnnotation currAnnot = annotIter.next();
            PDFPage page = currAnnot.getPage();
            page.getAnnotationList().remove(currAnnot);
        }
    }
}

