/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.types.ASName;

public enum PDFFieldType {
    Button(ASName.k_Btn),
    Choice(ASName.k_Ch),
    Text(ASName.k_Tx),
    Signature(ASName.k_Sig);

    private ASName value;

    private PDFFieldType(ASName type) {
        this.value = type;
    }

    static PDFFieldType getInstance(ASName type) {
        if (type == Button.getValue()) {
            return Button;
        }
        if (type == Choice.getValue()) {
            return Choice;
        }
        if (type == Text.getValue()) {
            return Text;
        }
        if (type == Signature.getValue()) {
            return Signature;
        }
        return null;
    }

    public ASName getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.asString(true);
    }
}

