/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNumeric;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.List;

public class PDFVertices
extends PDFCosArrayList<PDFCosNumeric> {
    private PDFVertices(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFVertices getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFVertices pdfObject = (PDFVertices)PDFCosObject.getCachedInstance(cosObject, PDFVertices.class);
        if (pdfObject == null) {
            pdfObject = new PDFVertices(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFCosNumeric itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        return PDFCosNumeric.getInstance(cosObject);
    }

    public static PDFVertices newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFVertices(cosObject);
    }

    public static PDFVertices newInstance(PDFDocument pdfDocument, List vertices) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!vertices.isEmpty()) {
            CosArray cosObject = PDFCosObject.makeCosArray(pdfDocument, vertices);
            return new PDFVertices(cosObject);
        }
        return PDFVertices.newInstance(pdfDocument);
    }
}

