/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExDataUnknown;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMultimediaUtil;

public abstract class PDFExData
extends PDFCosDictionary {
    public static final ASName k_Markup3D = ASName.create("Markup3D");
    public static final ASName k_3DM = ASName.create("3DM");
    public static final ASName k_MarkupGeo = ASName.create("MarkupGeo");
    public static final ASName k_RichMedia = ASName.create("RichMedia");

    protected PDFExData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private static void initialize(PDFCosDictionary exData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        exData.setDictionaryNameValue(ASName.k_Type, ASName.k_ExData);
    }

    public static PDFCosDictionary newInstance(PDFDocument pdfDocument, ASName subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCosDictionary exData = null;
        if (k_Markup3D.equals(subtype)) {
            exData = PDFMultimediaUtil.createPDFMultimediaObject("PDF3DExDataMarkup3D", pdfDocument);
        } else if (k_3DM.equals(subtype)) {
            exData = PDFMultimediaUtil.createPDFMultimediaObject("PDF3DExData3DM", pdfDocument);
        } else if (k_MarkupGeo.equals(subtype)) {
            exData = PDFMultimediaUtil.createPDFMultimediaObject("PDFExDataMarkupGeo", pdfDocument);
        }
        if (k_RichMedia.equals(subtype)) {
            exData = PDFMultimediaUtil.createPDFMultimediaObject("PDFExDataRichMedia", pdfDocument);
        }
        if (exData != null) {
            PDFExData.initialize(exData);
        }
        return exData;
    }

    public static PDFCosDictionary getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            return null;
        }
        ASName subType = ((CosDictionary)cosObject).getName(ASName.k_Subtype);
        if (subType == null) {
            return PDFExDataUnknown.getInstance(cosObject);
        }
        if (subType == k_Markup3D) {
            return PDFMultimediaUtil.createPDFMultimediaObject("PDF3DExDataMarkup3D", cosObject);
        }
        if (subType == k_3DM) {
            return PDFMultimediaUtil.createPDFMultimediaObject("PDF3DExData3DM", cosObject);
        }
        if (subType == k_MarkupGeo) {
            return PDFMultimediaUtil.createPDFMultimediaObject("PDFExDataMarkupGeo", cosObject);
        }
        if (subType == k_RichMedia) {
            return PDFMultimediaUtil.createPDFMultimediaObject("PDFExDataRichMedia", cosObject);
        }
        return PDFExDataUnknown.getInstance(cosObject);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Subtype);
    }

    public void setSubtype(ASName subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Subtype, subtype);
    }
}

