/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFFixedPrint;

public class PDFAnnotationWatermark
extends PDFAnnotation {
    private PDFAnnotationWatermark(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFAnnotationWatermark(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Watermark);
    }

    public static PDFAnnotationWatermark getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationWatermark pdfObject = (PDFAnnotationWatermark)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationWatermark.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationWatermark(cosObject);
        }
        return pdfObject;
    }

    public static PDFAnnotationWatermark newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationWatermark(pdfDocument);
    }

    public boolean hasFixedPrint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_FixedPrint);
    }

    public PDFFixedPrint getFixedPrint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFixedPrint.getInstance(this.getDictionaryDictionaryValue(ASName.k_FixedPrint));
    }

    public void setFixedPrint(PDFFixedPrint fixedPrint) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_FixedPrint, fixedPrint);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFixedPrint fixedPrint = this.getFixedPrint();
        if (fixedPrint != null) {
            ASMatrix transformation = fixedPrint.getTransformation();
            transformation = transformation.concat(matrix);
            fixedPrint.setTransformation(transformation);
            double h = fixedPrint.getHorizontalTransformation();
            double v = fixedPrint.getVerticalTransformation();
            PDFRectangle mediaBox = this.getPage().getMediaBox();
            double mediaHeight = mediaBox.height();
            double mediaWidth = mediaBox.width();
            ASCoordinate point = new ASCoordinate(h * mediaHeight, v * mediaWidth);
            ASCoordinate newPoint = point.transform(matrix);
            fixedPrint.setHorizontalTransformation(newPoint.x() / mediaHeight);
            fixedPrint.setVerticalTransformation(newPoint.y() / mediaWidth);
            this.setFixedPrint(fixedPrint);
        }
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

