/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIcon;

public class PDFAnnotationStamp
extends PDFAnnotationMarkup
implements PDFAnnotationWithIcon {
    private PDFAnnotationStamp(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationStamp getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationStamp pdfObject = (PDFAnnotationStamp)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationStamp.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationStamp(cosObject);
        }
        return pdfObject;
    }

    private PDFAnnotationStamp(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Stamp);
    }

    public static PDFAnnotationStamp newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationStamp(pdfDocument);
    }

    public String getIconNameAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasIconName()) {
            return this.getIconName().toString();
        }
        return null;
    }

    @Override
    public void setIconName(String icon) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Name, icon);
    }

    @Override
    public String getIconName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getDictionaryValue(ASName.k_Name);
        if (obj instanceof CosName) {
            return this.getDictionaryNameValue(ASName.k_Name).asString(true);
        }
        ASString asStr = this.getDictionaryStringValue(ASName.k_Name);
        return asStr != null ? asStr.asString() : null;
    }

    @Override
    public boolean hasIconName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Name);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    @Override
    public void setIntent(String intent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (intent.equalsIgnoreCase("StampSnapshot") || intent.equalsIgnoreCase("StampImage") || intent.equalsIgnoreCase("Stamp")) {
            this.setDictionaryNameValue(ASName.k_IT, intent);
        }
    }

    @Override
    public String getIntent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getDictionaryValue(ASName.k_IT);
        if (obj instanceof CosName) {
            return this.getDictionaryNameValue(ASName.k_IT).asString(true);
        }
        ASString asStr = this.getDictionaryStringValue(ASName.k_IT);
        return asStr != null ? asStr.asString() : ASName.k_Stamp.asString();
    }
}

