/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIntent;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExData;

public abstract class PDFAnnotationMarkup
extends PDFAnnotation
implements PDFAnnotationWithIntent {
    protected PDFAnnotationMarkup(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    protected PDFAnnotationMarkup(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
    }

    public String getTitle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_T);
    }

    public void setTitle(String title) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFText titleText = PDFText.createString(this.getPDFDocument(), title);
        this.setDictionaryTextValue(ASName.k_T, titleText);
    }

    public boolean hasPopup() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Popup);
    }

    public PDFAnnotationPopup getPopup() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationPopup.getInstance(this.getDictionaryCosObjectValue(ASName.k_Popup));
    }

    public void setPopup(PDFAnnotationPopup popupAnnotation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Popup, popupAnnotation);
    }

    public boolean hasOpacity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CA);
    }

    public Number getOpacity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number val = this.getDictionaryNumericValue(ASName.k_CA);
        if (val == null) {
            return 1.0;
        }
        return val;
    }

    public void setOpacity(Number value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_CA);
        } else {
            this.setDictionaryDoubleValue(ASName.k_CA, value.doubleValue());
        }
    }

    public String getRichContents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringOrStreamValue(ASName.k_RC);
    }

    public void setRichContents(String text) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringOrStreamValue(ASName.k_RC, text);
    }

    public boolean hasCreationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CreationDate);
    }

    public ASDate getCreationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_CreationDate);
    }

    public void setCreationDate(String date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFText dateText = PDFText.createString(this.getPDFDocument(), date);
        this.setDictionaryTextValue(ASName.k_CreationDate, dateText);
    }

    public String getCreationDateAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String result;
        block3: {
            result = "";
            try {
                ASDate dateResult = this.getCreationDate();
                if (dateResult != null) {
                    result = dateResult.asString();
                }
            }
            catch (Exception e) {
                CosString stringResult = (CosString)this.getDictionaryCosObjectValue(ASName.k_CreationDate);
                if (stringResult == null) break block3;
                result = stringResult.asString();
            }
        }
        return result;
    }

    public boolean hasSubject() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subj);
    }

    public String getSubject() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Subj);
    }

    public void setSubject(String subject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Subj, subject);
    }

    public void setSubject(String subject, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Subj, subject, unicode);
    }

    public PDFAnnotation getInReplyTo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationFactory.getInstance(this.getDictionaryCosObjectValue(ASName.k_IRT));
    }

    public void setInReplyTo(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_IRT, annot);
    }

    public String getReplyType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName rt = this.getDictionaryNameValue(ASName.k_RT);
        if (rt != null) {
            return rt.asString(true);
        }
        return "R";
    }

    public void setReplyType(String replyType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (replyType == null) {
            this.removeValue(ASName.k_RT);
        } else {
            this.setDictionaryNameValue(ASName.k_RT, ASName.create(replyType));
        }
    }

    @Override
    public String getIntent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName rt = this.getDictionaryNameValue(ASName.k_IT);
        if (rt == null) {
            return null;
        }
        return rt.asString(true);
    }

    protected boolean isIntentTypeValid(String intentType) {
        return true;
    }

    @Override
    public void setIntent(String intentType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isIntentTypeValid(intentType)) {
            this.setDictionaryNameValue(ASName.k_IT, ASName.create(intentType));
        }
    }

    @Override
    public boolean hasIntent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_IT);
    }

    public PDFExData getExData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (PDFExData)PDFExData.getInstance(this.getDictionaryDictionaryValue(ASName.k_ExData));
    }

    public void setExData(PDFExData exData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ExData, exData);
    }

    public boolean hasExData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ExData);
    }

    @Override
    public void applyRotation(PDFRectangle cropBox, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (rotationAngle == 0) {
            rotationAngle = this.getRotation();
        }
        double height = cropBox.height();
        double width = cropBox.width();
        double[] transformedRect = null;
        double[] transformedPopupRect = null;
        PDFAnnotationPopup popup = this.getPopup();
        transformedRect = PDFAnnotationUtils.transfromRectangle(this.getRect().getValues(), width, height, rotationAngle);
        if (popup != null) {
            transformedPopupRect = PDFAnnotationUtils.transfromRectangle(this.getPopup().getRect().getValues(), width, height, rotationAngle);
        }
        this.setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedRect[0], transformedRect[1], transformedRect[2], transformedRect[3]));
        if (popup != null) {
            this.getPopup().setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedPopupRect[0], transformedPopupRect[1], transformedPopupRect[2], transformedPopupRect[3]));
        }
    }
}

