/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionURI;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithQuadPoints;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;

public class PDFAnnotationLink
extends PDFAnnotation
implements PDFAnnotationWithQuadPoints {
    private PDFAnnotationLink(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFAnnotationLink(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Link);
    }

    public static PDFAnnotationLink getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationLink pdfObject = (PDFAnnotationLink)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationLink.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationLink(cosObject);
        }
        return pdfObject;
    }

    public static PDFAnnotationLink newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationLink(pdfDocument);
    }

    public boolean hasDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Dest);
    }

    public PDFDestination getDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestination.getInstance(this.getDictionaryCosObjectValue(ASName.k_Dest));
    }

    public void setDestination(PDFDestination dest) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Dest, dest);
    }

    public boolean removeDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.removeValue(ASName.k_Dest);
    }

    public boolean hasHighlight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_H);
    }

    public String getHighlight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName highlight = this.getDictionaryNameValue(ASName.k_H);
        return highlight == null ? null : highlight.asString(true);
    }

    public void setHighlight(String highlight) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationUtils.setHighlight(highlight, this);
    }

    public boolean hasPreviousAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PA);
    }

    public PDFActionURI getPreviousAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return (PDFActionURI)PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_PA));
    }

    public void setPreviousAction(PDFActionURI action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_PA, action);
    }

    @Override
    public boolean hasQuadPoints() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_QuadPoints);
    }

    @Override
    public double[] getQuadPoints() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosQuadPoints = this.getDictionaryArrayValue(ASName.k_QuadPoints);
        return cosQuadPoints.getArrayDouble();
    }

    @Override
    public void setQuadPoints(double[] quadPoints) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (quadPoints == null) {
            this.removeValue(ASName.k_QuadPoints);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < quadPoints.length; ++i) {
                cosArray.addDouble(quadPoints[i]);
            }
            this.setDictionaryArrayValue(ASName.k_QuadPoints, cosArray);
        }
    }

    @Override
    public void setQuadPoints(String points, String separator) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_QuadPoints, PDFUtil.parseNumbers(points, separator));
    }

    @Override
    public void transformQuadPoints(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasQuadPoints()) {
            double[] quadPoints = this.getQuadPoints();
            double[] newQuagPoints = new double[quadPoints.length];
            for (int i = 0; i < quadPoints.length; i += 2) {
                ASCoordinate point = new ASCoordinate(quadPoints[i], quadPoints[i + 1]);
                ASCoordinate newPoint = point.transform(matrix);
                newQuagPoints[i] = newPoint.x();
                newQuagPoints[i + 1] = newPoint.y();
            }
            this.setQuadPoints(newQuagPoints);
        }
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.transformQuadPoints(matrix);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    public boolean containedWithin(double[] quads) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle outerRect = new ASRectangle(quads);
        ASRectangle innerRect = new ASRectangle(this.getRect().getRectangle());
        return outerRect.contains(innerRect);
    }

    @Override
    public void applyRotation(PDFRectangle cropBox, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (rotationAngle == 0) {
            rotationAngle = this.getRotation();
        }
        double height = cropBox.height();
        double width = cropBox.width();
        double[] transformedRect = null;
        double[] transformedQuadPoints = null;
        transformedRect = PDFAnnotationUtils.transfromRectangle(this.getRect().getValues(), width, height, rotationAngle);
        transformedQuadPoints = PDFAnnotationUtils.transfromRectangle(this.getQuadPoints(), width, height, rotationAngle);
        this.setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedRect[0], transformedRect[1], transformedRect[2], transformedRect[3]));
        this.setQuadPoints(transformedQuadPoints);
    }
}

