/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFRichMediaCommand
extends PDFCosDictionary {
    protected PDFRichMediaCommand(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaCommand newInstance(PDFDocument pdfDocument, ASName script) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (script == null) {
            throw new PDFInvalidParameterException("script is required when creating newInstance of PDFRichMediaCommand.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaCommand pdfObject = new PDFRichMediaCommand(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_RichMediaCommand);
        pdfObject.setScript(script);
        return pdfObject;
    }

    public static PDFRichMediaCommand getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaCommand pdfObject = (PDFRichMediaCommand)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaCommand.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaCommand(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setScript(ASName script) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_C, script);
    }

    public ASName getScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_C);
    }

    public void setArguments(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_A, value);
    }

    public void setArguments(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_A, value);
    }

    public void setArguments(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_A, value.intValue());
    }

    public void setArguments(Double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_A, value);
    }

    public Object getArguments() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryValue(ASName.k_A);
    }
}

