/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;

public class PDFAdditionalActionsAnnotation
extends PDFAdditionalActions {
    static final ASName k_PO = ASName.create("PO");
    static final ASName k_PC = ASName.create("PC");
    static final ASName k_PV = ASName.create("PV");
    static final ASName k_PI = ASName.create("PI");

    protected PDFAdditionalActionsAnnotation(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFAdditionalActionsAnnotation(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
    }

    public static PDFAdditionalActionsAnnotation getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return new PDFAdditionalActionsAnnotation(cosObject);
    }

    public static PDFAdditionalActionsAnnotation newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAdditionalActionsAnnotation(pdfDocument);
    }

    @Override
    protected PDFAction itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(cosObject);
    }

    public PDFAction getActionOnCursorEnters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_E));
    }

    public void setActionOnCursorEnters(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_E, action);
    }

    public PDFAction getActionOnCursorExits() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_X));
    }

    public void setActionOnCursorExits(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_X, action);
    }

    public PDFAction getActionOnButtonDown() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_D));
    }

    public void setActionOnButtonDown(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_D, action);
    }

    public PDFAction getActionOnButtonUp() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_U));
    }

    public void setActionOnButtonUp(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_U, action);
    }

    public PDFAction getActionOnPageOpen() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_PO));
    }

    public void setActionOnPageOpen(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_PO, action);
    }

    public PDFAction getActionOnPageClose() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_PC));
    }

    public void setActionOnPageClose(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_PC, action);
    }

    public PDFAction getActionOnPageVisable() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_PV));
    }

    public void setActionOnPageVisable(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_PV, action);
    }

    public PDFAction getActionOnPageInvisible() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_PI));
    }

    public void setActionPageOnInvisible(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_PI, action);
    }
}

