/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMultimediaUtil;

public class PDFActionSound
extends PDFAction {
    private PDFActionSound(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionSound(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_Sound);
    }

    public static PDFActionSound getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionSound pdfObject = (PDFActionSound)PDFCosObject.getCachedInstance(cosObject, PDFActionSound.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionSound(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionSound newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return new PDFActionSound(pdfDocument);
    }

    public static PDFActionSound newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionSound = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionSound.put(ASName.k_Type, ASName.k_Action);
        cosActionSound.put(ASName.k_S, ASName.k_Sound);
        return PDFActionSound.getInstance(cosActionSound);
    }

    public boolean hasSound() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Sound);
    }

    public PDFCosStream getSound() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return (PDFCosStream)PDFMultimediaUtil.createPDFMultimediaObject("PDFSound", this.getDictionaryCosObjectValue(ASName.k_Sound));
    }

    public void setSound(PDFCosStream sound) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Sound, sound);
    }

    public void setDestination(PDFStream sound) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Sound, sound);
    }

    public boolean hasVolume() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Volume);
    }

    public double getVolume() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getDictionaryNumericValue(ASName.k_Volume).doubleValue();
    }

    public void setVolume(double volume) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Volume, volume);
    }

    public boolean hasSynchronous() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Synchronous);
    }

    public boolean getSynchronous() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Synchronous);
    }

    public void setSynchronous(boolean synchronous) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Synchronous, synchronous);
    }

    public boolean hasRepeat() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Repeat);
    }

    public boolean getRepeat() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Repeat);
    }

    public void setRepeat(boolean repeat) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Repeat, repeat);
    }

    public boolean hasMix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Mix);
    }

    public boolean getMix() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Mix);
    }

    public void setMix(boolean mix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Mix, mix);
    }
}

