/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMultimediaUtil;

public class PDFActionGoTo3DView
extends PDFAction {
    private PDFActionGoTo3DView(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFActionGoTo3DView(PDFDocument pdfDocument, PDFAnnotation3D value, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_GoTo3DView);
        this.setTA(value);
        this.setView(dict);
    }

    public static PDFActionGoTo3DView newInstance(PDFDocument pdfDocument, PDFAnnotation3D value, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("TA is a required entry it can't be null");
        }
        if (dict == null) {
            throw new PDFInvalidDocumentException("View is a required entry it can't be null");
        }
        return new PDFActionGoTo3DView(pdfDocument, value, dict);
    }

    public static PDFActionGoTo3DView getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionGoTo3DView pdfObject = (PDFActionGoTo3DView)PDFCosObject.getCachedInstance(cosObject, PDFActionGoTo3DView.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionGoTo3DView(cosObject);
        }
        return pdfObject;
    }

    public int getViewAsInteger() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_V);
    }

    public void setView(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_V, value);
    }

    public ASString getViewAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_V);
    }

    public void setView(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidDocumentException("View is a required field,it can't be null");
        }
        this.setDictionaryASStringValue(ASName.k_V, value);
    }

    public ASName getViewAsName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_V);
        return ((CosName)cosObject).nameValue();
    }

    public void setView(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("View is a required field,it can't be null");
        }
        this.setDictionaryNameValue(ASName.k_V, value);
    }

    public PDFCosDictionary getViewAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDF3DVDict", this.getDictionaryCosObjectValue(ASName.k_V));
    }

    public void setView(PDFCosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("View is a required field,it can't be null");
        }
        this.setDictionaryValue(ASName.k_V, value);
    }

    public boolean hasView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_V);
    }

    public PDFAnnotation3D getTA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotation3D.getInstance(this.getDictionaryCosObjectValue(ASName.k_TA));
    }

    public void setTA(PDFAnnotation3D value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("TA is a required key, It can't be null");
        }
        this.setDictionaryValue(ASName.k_TA, value);
    }

    public boolean hasTA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TA);
    }
}

