/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionForm;

public class PDFActionFormImportData
extends PDFActionForm {
    private PDFActionFormImportData(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFActionFormImportData(PDFDocument pdfDocument, PDFFileSpecification key_F) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(pdfDocument);
        this.setSubtype(ASName.k_ImportData);
        this.setFileSpecification(key_F);
    }

    public static PDFActionFormImportData newInstance(PDFDocument pdfDocument, PDFFileSpecification key_F) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_F == null) {
            throw new PDFInvalidDocumentException("F is required when creating newInstance of PDFActionImportData.");
        }
        return new PDFActionFormImportData(pdfDocument, key_F);
    }

    public static PDFActionFormImportData getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionFormImportData pdfObject = (PDFActionFormImportData)PDFCosObject.getCachedInstance(cosObject, PDFActionFormImportData.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionFormImportData(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionFormImportData newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionFormImportData = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionFormImportData.put(ASName.k_Type, ASName.k_Action);
        cosActionFormImportData.put(ASName.k_S, ASName.k_ImportData);
        return PDFActionFormImportData.getInstance(cosActionFormImportData);
    }

    @Override
    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public void setFileSpecification(PDFFileSpecification value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("F is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_F, value);
    }

    public boolean hasFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }
}

