/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.xobject;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.spi.ImageFilterInterface;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Parser;
import java.io.IOException;

class PDFXObjectUtil {
    PDFXObjectUtil() {
    }

    static Number getValidBitsPerComponentValue(PDFXObjectImage xObjImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = xObjImage.getDictionaryNumericValue(ASName.k_BitsPerComponent);
        if (value == null) {
            PDFFilter filter;
            if (xObjImage.getIsImageMask()) {
                return 1;
            }
            PDFFilterList filterList = xObjImage.getInputFilters();
            if (filterList != null && filterList.size() == 1 && (filter = (PDFFilter)filterList.get(0)).getFilterName() == ASName.create("JPXDecode")) {
                try {
                    ImageFilterInterface.ImageInfo imageInfo = Jpeg2000Parser.getImageInfo(Jpeg2000Parser.parse(xObjImage.getCosStream().getStreamEncoded()));
                    return imageInfo.getBitDepth() > 8 ? 8 : imageInfo.getBitDepth();
                }
                catch (IOException e) {
                    throw new PDFIOException("Error parsing Jpeg2000 metadata.", e);
                }
            }
        }
        return value;
    }
}

