/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.shading;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionsArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingNoMeshes;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingType;

public class PDFShadingAxial
extends PDFShadingNoMeshes {
    private PDFShadingAxial(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFShadingAxial(PDFDocument pdfDocument, PDFFunction key_FunctionOrFunctionsArray, CosArray key_Coords) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
        this.setFunctionArray(key_FunctionOrFunctionsArray);
        this.setShadingType(PDFShadingType.SHADING_TYPE_AXIAL.getValue());
        this.setCoords(key_Coords);
    }

    public static PDFShadingAxial newInstance(PDFDocument pdfDocument, PDFFunction key_FunctionOrFunctionsArray, CosArray key_Coords) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_FunctionOrFunctionsArray == null) {
            throw new PDFInvalidParameterException("FunctionOrFunctionsArray is required when creating newInstance of PDFShadingAxial.");
        }
        if (key_Coords == null) {
            throw new PDFInvalidParameterException("Coords is required when creating newInstance of PDFShadingAxial.");
        }
        return new PDFShadingAxial(pdfDocument, key_FunctionOrFunctionsArray, key_Coords);
    }

    public static PDFShadingAxial getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFShadingAxial pdfObject = (PDFShadingAxial)PDFCosObject.getCachedInstance(cosObject, PDFShadingAxial.class);
        if (pdfObject == null) {
            pdfObject = new PDFShadingAxial(cosObject);
        }
        return pdfObject;
    }

    public CosArray getExtend() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Extend);
    }

    public void setExtend(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Extend, value);
    }

    public boolean hasExtend() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Extend);
    }

    public CosArray getDomain() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Domain);
    }

    public void setDomain(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Domain, value);
    }

    public boolean hasDomain() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Domain);
    }

    public CosArray getCoords() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Coords);
    }

    public void setCoords(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Coords is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Coords, value);
    }

    public boolean hasCoords() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Coords);
    }

    public void setFunctionArray(PDFFunction value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFunctionArray(value, true);
    }

    public void setFunctionArray(PDFFunctionsArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFunctionArray(children, true);
    }
}

