/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.patterns;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import java.io.IOException;

public class PDFPatternTiling
extends PDFCosStream
implements PDFPattern {
    private PDFPatternTiling(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFPatternTiling(PDFDocument pdfDocument, PDFRectangle key_BBox, PDFResources key_Resources, int key_PaintType, int key_TilingType, double key_XStep, double key_YStep) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(PDFCosObject.newCosStream(pdfDocument));
        this.setBBox(key_BBox);
        this.setResources(key_Resources);
        this.setDictionaryIntValue(ASName.k_PatternType, 1L);
        this.setPaintType(key_PaintType);
        this.setTilingType(key_TilingType);
        this.setXStep(key_XStep);
        this.setYStep(key_YStep);
    }

    public static PDFPatternTiling newInstance(PDFDocument pdfDocument, PDFRectangle key_BBox, PDFResources key_Resources, int key_PaintType, int key_TilingType, double key_XStep, double key_YStep) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_BBox == null) {
            throw new PDFInvalidParameterException("BBox is required when creating newInstance of PDFPatternTiling.");
        }
        if (key_Resources == null) {
            throw new PDFInvalidParameterException("Resources is required when creating newInstance of PDFPatternTiling.");
        }
        return new PDFPatternTiling(pdfDocument, key_BBox, key_Resources, key_PaintType, key_TilingType, key_XStep, key_YStep);
    }

    public static PDFPatternTiling getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPatternTiling pdfObject = (PDFPatternTiling)PDFCosObject.getCachedInstance(cosObject, PDFPatternTiling.class);
        if (pdfObject == null) {
            pdfObject = new PDFPatternTiling(cosObject);
        }
        return pdfObject;
    }

    @Override
    public int getPatternType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return 1;
    }

    public double getYStep() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_YStep);
    }

    public void setYStep(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_YStep, value);
    }

    public double requireYStep() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_YStep);
        if (cosObject == null) {
            throw new PDFInvalidDocumentException("Unable to get YStep.");
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public boolean hasYStep() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_YStep);
    }

    public CosArray getMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (CosArray)this.getDictionaryValue(ASName.k_Matrix);
    }

    public void setMatrix(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Matrix, value);
    }

    public boolean hasMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Matrix);
    }

    public int getTilingType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_TilingType);
    }

    public void setTilingType(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_TilingType, value);
    }

    public int requireTilingType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_TilingType);
        if (cosObject == null) {
            throw new PDFInvalidDocumentException("Unable to get TilingType.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasTilingType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TilingType);
    }

    public PDFRectangle getBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.getInstance(this.getDictionaryCosObjectValue(ASName.k_BBox));
    }

    public void setBBox(PDFRectangle children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            throw new PDFInvalidParameterException("BBox is a required key therefore cannot be removed.");
        }
        this.setDictionaryArrayValue(ASName.k_BBox, children.getCosArray());
    }

    public boolean hasBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BBox);
    }

    public int getPaintType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_PaintType);
    }

    public void setPaintType(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_PaintType, value);
    }

    public int requirePaintType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_PaintType);
        if (cosObject == null) {
            throw new PDFInvalidDocumentException("Unable to get PaintType.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasPaintType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PaintType);
    }

    public PDFResources getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFResources.getInstance(this.getDictionaryCosObjectValue(ASName.k_Resources));
    }

    public void setResources(PDFResources value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Resources is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Resources, value);
    }

    public PDFResources requireResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources pdfObject = PDFResources.getInstance(this.getDictionaryCosObjectValue(ASName.k_Resources));
        if (pdfObject == null) {
            throw new PDFInvalidDocumentException("Could not get Resources");
        }
        return pdfObject;
    }

    public boolean hasResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Resources);
    }

    public double getXStep() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_XStep);
    }

    public void setXStep(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_XStep, value);
    }

    public double requireXStep() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_XStep);
        if (cosObject == null) {
            throw new PDFInvalidDocumentException("Unable to get XStep.");
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public boolean hasXStep() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_XStep);
    }

    public PDFContents getContents() throws PDFInvalidDocumentException {
        return PDFContents.getInstance(this.getCosObject());
    }

    public void setContents(PDFContents pdfContents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfContents == null) {
            throw new PDFInvalidDocumentException("Invalid Parameter: pdfContents is null");
        }
        InputByteStream contents = pdfContents.getContents();
        try {
            if (contents != null) {
                this.setStreamData(contents.toInputStream());
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (contents != null) {
                    contents.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public PDFCosDictionary getPDFCosObject() {
        return this;
    }
}

