/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCContentUsageUserList;

public class PDFOCUsage
extends PDFCosDictionary {
    private PDFOCUsage(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCUsage getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCUsage pdfObject = (PDFOCUsage)PDFCosObject.getCachedInstance(cosObject, PDFOCUsage.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCUsage(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCUsage newInstance(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFOCUsage(PDFCosObject.newCosDictionary(pdfDoc));
    }

    public ASName getUserType() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosDictionary userObj = this.getDictionaryDictionaryValue(ASName.k_User);
        if (userObj != null) {
            return userObj.getName(ASName.k_Type);
        }
        return null;
    }

    public void setUserType(UserType userType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (userType == null) {
            CosDictionary userObj = this.getDictionaryDictionaryValue(ASName.k_User);
            if (userObj != null) {
                userObj.remove(ASName.k_Type);
            }
        } else {
            this.setUserType(userType.getName());
        }
    }

    public CosDictionary getUser() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDictionaryValue(ASName.k_User);
    }

    public void setUser(ASName userType, PDFOCContentUsageUserList userName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (userType == null || userName == null) {
            return;
        }
        CosDictionary userObj = PDFCosObject.newCosDictionary(this.getPDFDocument());
        userObj.put(ASName.k_Type, userType);
        userObj.put(ASName.k_Name, userName.getCosObject());
        this.setDictionaryValue(ASName.k_User, userObj);
    }

    public void addUserName(ASString user) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary userObj = this.getDictionaryDictionaryValue(ASName.k_User);
        if (userObj != null) {
            CosObject obj = userObj.get(ASName.k_Name);
            if (obj instanceof CosString) {
                PDFOCContentUsageUserList newList = PDFOCContentUsageUserList.newInstance(this.getPDFDocument(), ((CosString)obj).stringValue());
                userObj.put(ASName.k_Name, newList.getCosObject());
                obj = newList.getCosObject();
            }
            if (obj instanceof CosArray) {
                CosArray arrayObj = (CosArray)obj;
                arrayObj.addString(user);
            }
        }
    }

    private void setUserType(ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary userObj = this.getDictionaryDictionaryValue(ASName.k_User);
        if (userObj != null) {
            userObj.put(ASName.k_Type, type);
        }
    }

    public void setZoomMaxMagnification(long maxMag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary zoomObj = this.getDictionaryDictionaryValue(ASName.k_Zoom);
        if (zoomObj == null) {
            zoomObj = PDFCosObject.newCosDictionary(this.getPDFDocument());
            this.setDictionaryValue(ASName.k_Zoom, zoomObj);
        }
        zoomObj.put(ASName.k_max, maxMag);
    }

    public void setZoomMinMagnification(long minMag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary zoomObj = this.getDictionaryDictionaryValue(ASName.k_Zoom);
        if (zoomObj == null) {
            zoomObj = PDFCosObject.newCosDictionary(this.getPDFDocument());
            this.setDictionaryValue(ASName.k_Zoom, zoomObj);
        }
        zoomObj.put(ASName.k_min, minMag);
    }

    public long getZoomMaxMagnification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        long result = 0L;
        CosDictionary zoomObj = this.getDictionaryDictionaryValue(ASName.k_Zoom);
        if (zoomObj != null && zoomObj.containsKey(ASName.k_max)) {
            result = zoomObj.getLong(ASName.k_max);
        }
        return result;
    }

    public long getZoomMinMagnification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        long result = 9999999L;
        CosDictionary zoomObj = this.getDictionaryDictionaryValue(ASName.k_Zoom);
        if (zoomObj != null && zoomObj.containsKey(ASName.k_min)) {
            result = zoomObj.getLong(ASName.k_min);
        }
        return result;
    }

    public void setLanguage(ASString languageSpec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary langObj = PDFCosObject.newCosDictionary(this.getPDFDocument());
        langObj.put(ASName.k_Lang, languageSpec);
        this.setDictionaryValue(ASName.k_Language, langObj);
    }

    public ASString getLanguageSpec() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary langObj = this.getDictionaryDictionaryValue(ASName.k_Language);
        ASString langval = langObj.getString(ASName.k_Lang);
        return langval;
    }

    public ASName getLanguagePref() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosDictionary langObj = this.getDictionaryDictionaryValue(ASName.k_Language);
        if (langObj != null) {
            return langObj.getName(ASName.k_Preferred);
        }
        return ASName.k_OFF;
    }

    public void setLanguagePreferred(boolean isOn) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (isOn) {
            this.setLanguagePref(ASName.k_ON);
        } else {
            this.setLanguagePref(ASName.k_OFF);
        }
    }

    private void setLanguagePref(ASName pref) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary langObj = this.getDictionaryDictionaryValue(ASName.k_Language);
        if (langObj != null) {
            langObj.put(ASName.k_Preferred, pref);
        }
    }

    public ASName getCreatorInfoSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj;
        ASName result = null;
        CosDictionary creatorDict = this.getDictionaryDictionaryValue(ASName.k_CreatorInfo);
        if (creatorDict != null && (obj = creatorDict.get(ASName.k_Subtype)) instanceof CosName) {
            result = ((CosName)obj).nameValue();
        }
        return result;
    }

    public void setCreatorInfoSubtype(ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary creatorDict = this.getDictionaryDictionaryValue(ASName.k_CreatorInfo);
        if (creatorDict == null) {
            creatorDict = PDFCosObject.newCosDictionary(this.getPDFDocument());
        }
        creatorDict.put(ASName.k_Subtype, type);
    }

    public String getCreatorInfoCreator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj;
        String result = null;
        CosDictionary creatorDict = this.getDictionaryDictionaryValue(ASName.k_CreatorInfo);
        if (creatorDict != null && (obj = creatorDict.get(ASName.k_Creator)) instanceof CosString) {
            result = ((CosString)obj).toString();
        }
        return result;
    }

    public void setCreatorInfoCreator(String appName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (appName == null) {
            return;
        }
        CosDictionary creatorDict = this.getDictionaryDictionaryValue(ASName.k_CreatorInfo);
        if (creatorDict == null) {
            creatorDict = PDFCosObject.newCosDictionary(this.getPDFDocument());
            this.setDictionaryValue(ASName.k_CreatorInfo, creatorDict);
        }
        PDFText textString = PDFText.createString(this.getPDFDocument(), appName);
        creatorDict.put(ASName.k_Creator, new ASString(textString.stringValue()));
    }

    public ASName getPrintState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj;
        ASName result = null;
        CosDictionary printDict = this.getDictionaryDictionaryValue(ASName.k_Print);
        if (printDict != null && (obj = printDict.get(ASName.k_PrintState)) instanceof CosName) {
            result = ((CosName)obj).nameValue();
        }
        return result;
    }

    public void setPrintState(boolean isOn) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (isOn) {
            this.setPrintState(ASName.k_ON);
        } else {
            this.setPrintState(ASName.k_OFF);
        }
    }

    private void setPrintState(ASName state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary printDict = this.getDictionaryDictionaryValue(ASName.k_Print);
        if (printDict == null) {
            printDict = PDFCosObject.newCosDictionary(this.getPDFDocument());
            this.setDictionaryValue(ASName.k_Print, printDict);
        }
        printDict.put(ASName.k_PrintState, state);
    }

    public ASName getPrintSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj;
        ASName result = null;
        CosDictionary printDict = this.getDictionaryDictionaryValue(ASName.k_Print);
        if (printDict != null && (obj = printDict.get(ASName.k_Subtype)) instanceof CosName) {
            result = ((CosName)obj).nameValue();
        }
        return result;
    }

    public void setPrintSubtype(ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary printDict = this.getDictionaryDictionaryValue(ASName.k_Print);
        if (printDict == null) {
            printDict = PDFCosObject.newCosDictionary(this.getPDFDocument());
            this.setDictionaryValue(ASName.k_Print, printDict);
        }
        printDict.put(ASName.k_Subtype, type);
    }

    public ASName getExport() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj;
        ASName result = null;
        CosDictionary exportDict = this.getDictionaryDictionaryValue(ASName.k_Export);
        if (exportDict != null && (obj = exportDict.get(ASName.k_ExportState)) instanceof CosName) {
            result = ((CosName)obj).nameValue();
        }
        return result;
    }

    public void setExport(boolean isOn) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (isOn) {
            this.setExport(ASName.k_ON);
        } else {
            this.setExport(ASName.k_OFF);
        }
    }

    private void setExport(ASName state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary exportDict = this.getDictionaryDictionaryValue(ASName.k_Export);
        if (exportDict == null) {
            exportDict = PDFCosObject.newCosDictionary(this.getPDFDocument());
            this.setDictionaryValue(ASName.k_Export, exportDict);
        }
        exportDict.put(ASName.k_ExportState, state);
    }

    public ASName getView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj;
        ASName result = null;
        CosDictionary viewDict = this.getDictionaryDictionaryValue(ASName.k_View);
        if (viewDict != null && (obj = viewDict.get(ASName.k_ViewState)) instanceof CosName) {
            result = ((CosName)obj).nameValue();
        }
        return result;
    }

    public void setView(boolean isOn) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (isOn) {
            this.setView(ASName.k_ON);
        } else {
            this.setView(ASName.k_OFF);
        }
    }

    private void setView(ASName state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary viewDict = this.getDictionaryDictionaryValue(ASName.k_View);
        if (viewDict == null) {
            viewDict = PDFCosObject.newCosDictionary(this.getPDFDocument());
            this.setDictionaryValue(ASName.k_View, viewDict);
        }
        viewDict.put(ASName.k_ViewState, state);
    }

    public ASName getPageElementSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary pageElemDict = this.getDictionaryDictionaryValue(ASName.k_PageElement);
        if (pageElemDict != null) {
            return this.getDictionaryNameValue(ASName.k_Subtype);
        }
        return null;
    }

    public void setPageElementSubtype(PageElementSubtype elementSubtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (elementSubtype == null) {
            this.setPaginationSubtype(null);
        } else {
            this.setPaginationSubtype(elementSubtype.getName());
        }
    }

    private void setPaginationSubtype(ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary pageElemDict = this.getDictionaryDictionaryValue(ASName.k_PageElement);
        if (pageElemDict == null) {
            pageElemDict = PDFCosObject.newCosDictionary(this.getPDFDocument());
            this.setDictionaryValue(ASName.k_PageElement, pageElemDict);
        }
        if (type == null) {
            pageElemDict.remove(ASName.k_Subtype);
        } else {
            pageElemDict.put(ASName.k_Subtype, type);
        }
    }

    public static enum UserType {
        IND(ASName.k_Ind),
        ORG(ASName.k_Org),
        TTL(ASName.k_Ttl);

        private ASName name;

        private UserType(ASName name) {
            this.name = name;
        }

        public ASName getName() {
            return this.name;
        }
    }

    public static enum PageElementSubtype {
        BG(ASName.k_BG),
        FG(ASName.k_FG),
        HF(ASName.k_HF),
        L(ASName.k_L);

        private ASName name;

        private PageElementSubtype(ASName name) {
            this.name = name;
        }

        public ASName getName() {
            return this.name;
        }
    }
}

