/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.impl;

import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.color.ColorSpace;
import com.adobe.internal.pdftoolkit.color.Function;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFFunctionIdentity;
import java.awt.image.ColorModel;

public abstract class PDFColorSpaceWithTintTransform
extends PDFColorSpace
implements ColorSpace {
    protected PDFColorSpaceWithTintTransform(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    @Override
    public java.awt.color.ColorSpace createColorSpace() {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    public PDFColorSpace getAlternateColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject alternate = this.getCosArray().get(2);
        return PDFColorSpaceFactory.getInstance(alternate);
    }

    public void setAlternateColorSpace(PDFColorSpace cs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (cs == null) {
            throw new PDFInvalidParameterException("alternate color space cannot be null");
        }
        this.getCosArray().set(2, cs.getCosObject());
    }

    @Override
    public double[] toRGB(double[] inputColorValues) {
        inputColorValues = super.toRGB(inputColorValues);
        try {
            return ColorManager.colorSpaceWithTintTransformToRGB(inputColorValues, this.getTintTransform(), this.getAlternateColorSpace());
        }
        catch (PDFCosParseException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
    }

    public Function getTintTransform() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getCosArray().get(3);
        if (cosObject.getType() == 3 && ((CosName)cosObject).nameValue() == ASName.k_Identity) {
            return PDFFunction.getIdentityFunction();
        }
        return PDFFunctionFactory.getInstance(this.getCosArray().get(3));
    }

    @Override
    public double[] getRange() {
        try {
            Function function = this.getTintTransform();
            if (function instanceof PDFFunctionIdentity) {
                return this.getAlternateColorSpace().getRange();
            }
            return ((PDFFunction)function).getFunctionDomain().getCosArray().getArrayDouble();
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
    }
}

