/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.impl;

import com.adobe.internal.pdftoolkit.color.ApplyFunctionInterface;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionsArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PostScriptCalculator;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PostScriptStack;
import java.util.Arrays;
import java.util.Iterator;

class FunctionManager {
    private FunctionManager() {
    }

    static double[] applyFunction0(double[] inputData, byte[] sampledData, double[] domain, double[] range, double[] decode, double[] encode, double[] size, int bps, int valToBeInterpolated) {
        int n = range.length / 2;
        double[] data = new double[inputData.length];
        System.arraycopy(inputData, 0, data, 0, inputData.length);
        double[] result = new double[n];
        for (int i = 0; i < data.length; ++i) {
            data[i] = FunctionManager.min(FunctionManager.max(data[i], domain[2 * i]), domain[2 * i + 1]);
            data[i] = FunctionManager.interpolate(data[i], domain[2 * i], domain[2 * i + 1], encode[2 * i], encode[2 * i + 1]);
            data[i] = FunctionManager.min(FunctionManager.max(data[i], 0.0), size[i] - 1.0);
        }
        int pos = n * GraphicsUtils.rint(data[0]);
        double mult = 1.0;
        for (int i = 1; i < data.length; ++i) {
            pos = (int)((double)pos + (mult *= size[i - 1]) * (double)n * (double)GraphicsUtils.rint(data[i]));
        }
        for (int j = 0; j < n; ++j) {
            if (sampledData.length > 0) {
                result[j] = GraphicsUtils.readNthSample(sampledData, bps, pos + j);
            }
            if (result[j] < 0.0) {
                int n2 = j;
                result[n2] = result[n2] + (double)(valToBeInterpolated + 1);
            }
            result[j] = FunctionManager.interpolate(result[j], 0.0, valToBeInterpolated, decode[2 * j], decode[2 * j + 1]);
            result[j] = FunctionManager.min(FunctionManager.max(result[j], range[2 * j]), range[2 * j + 1]);
        }
        return result;
    }

    static double[] applyFunction2(double[] inputData, double[] C0, double[] C1, double N, int n, double[] range) {
        if (N - (double)((int)N) != 0.0 && inputData[0] < 0.0) {
            throw new PDFRuntimeException("Input Data " + inputData + " must be non Negative as N " + N + " is not an integer.");
        }
        if (N < 0.0 && inputData[0] == 0.0) {
            throw new PDFRuntimeException("if N " + N + " is negative, no value of input data " + inputData + "may be zero.");
        }
        if (C0.length != n) {
            throw new PDFRuntimeException("The length of the C0 Array shoule be " + n);
        }
        if (C1.length != n) {
            throw new PDFRuntimeException("The length of the C1 Array shoule be " + n);
        }
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            double C0i;
            double d = range != null ? (C0[i] < range[n * 2 - 2] ? range[n * 2 - 2] : C0[i]) : (C0i = C0[i]);
            double C1i = range != null ? (C1[i] > range[n * 2 - 1] ? range[n * 2 - 1] : C1[i]) : C1[i];
            result[i] = C0i + Math.pow(inputData[0], N) * (C1i - C0i);
            if (range == null) continue;
            result[i] = Math.min(FunctionManager.max(result[i], range[2 * i]), range[2 * i + 1]);
        }
        return result;
    }

    static double[] applyFunction3(double[] domain, double[] bounds, double[] encode, double[] inputData, ApplyFunctionInterface[] functionsArray) {
        int k = functionsArray.length;
        ApplyFunctionInterface function = null;
        if (domain.length != 2) {
            throw new PDFRuntimeException("Domain must be of size 2.");
        }
        double lowerBound = 0.0;
        double upperBound = 0.0;
        int index = 0;
        if (bounds.length > 0) {
            if (inputData[0] >= domain[0] && inputData[0] < bounds[0]) {
                lowerBound = domain[0];
                upperBound = bounds[0];
                index = 0;
                function = functionsArray[0];
            } else if (inputData[0] <= domain[1] && inputData[0] >= bounds[k - 2]) {
                lowerBound = bounds[k - 2];
                upperBound = domain[1];
                index = k - 1;
                function = functionsArray[k - 1];
            } else {
                for (int i = 0; i < k - 2; ++i) {
                    lowerBound = bounds[i];
                    upperBound = bounds[i + 1];
                    if (!(inputData[0] >= lowerBound) || !(inputData[0] < upperBound)) continue;
                    index = i + 1;
                    function = functionsArray[i + 1];
                    break;
                }
            }
        } else {
            lowerBound = domain[0];
            upperBound = domain[1];
            if (inputData[0] >= lowerBound && inputData[0] <= upperBound) {
                index = 0;
                function = functionsArray[0];
            }
        }
        double xdash = FunctionManager.interpolate(inputData[0], lowerBound, upperBound, encode[2 * index], encode[2 * index + 1]);
        return function.apply(new double[]{xdash});
    }

    static double[] applyFunction4(double[] range, double[] domain, PostScriptCalculator postScriptCalculator, double[] inputData) {
        int i;
        if (range == null) {
            throw new PDFRuntimeException("Required Range Entry is missing.");
        }
        int size = range.length / 2;
        double[] evaluatedData = new double[size];
        PostScriptStack<Double> data = new PostScriptStack<Double>();
        for (i = 0; i < inputData.length; ++i) {
            data.push(inputData[i]);
        }
        try {
            data = postScriptCalculator.evaluate(data);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        if (data.size() < size) {
            throw new PDFRuntimeException("Output of the funtion type 4 should be greater or equal to it's range/2.");
        }
        for (i = 0; i < evaluatedData.length; ++i) {
            evaluatedData[evaluatedData.length - i - 1] = data.pop();
        }
        return evaluatedData;
    }

    private static double max(double a, double b) {
        return a >= b ? a : b;
    }

    private static double min(double a, double b) {
        return a <= b ? a : b;
    }

    private static double interpolate(double a, double b, double c, double d, double e) {
        double bound = c - b;
        if (bound != 0.0) {
            return d + (a - b) * ((e - d) / bound);
        }
        return 0.0;
    }

    static double[] getDefaultArray(double value, double n) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        double[] list = new double[(int)n];
        Arrays.fill(list, value);
        return list;
    }

    static ApplyFunctionInterface[] pdfFunctionsArrayToInterfaceArray(PDFFunctionsArray functionsArray) {
        Iterator itr = functionsArray.iterator();
        ApplyFunctionInterface[] interfaceArray = new ApplyFunctionInterface[functionsArray.size()];
        int index = 0;
        while (itr.hasNext()) {
            interfaceArray[index++] = (ApplyFunctionInterface)itr.next();
        }
        return interfaceArray;
    }
}

