/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.impl;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

class CompressedCmapLineReader
extends LineNumberReader {
    private static final String EOF_STRING = "%%EOF";
    private static final String BEGIN_RESOURCE_START_STRING = "%%BeginResource: CMap (";
    private boolean cmapEof;
    private boolean actualEof;
    private String cmapName;

    public CompressedCmapLineReader(Reader in) throws IOException {
        super(in);
    }

    @Override
    public String readLine() throws IOException {
        if (this.cmapEof) {
            return null;
        }
        String line = super.readLine();
        if (line == null) {
            this.actualEof = true;
            return null;
        }
        if (EOF_STRING.equals(line)) {
            this.cmapEof = true;
            return null;
        }
        if (this.cmapName == null && line.startsWith(BEGIN_RESOURCE_START_STRING)) {
            this.cmapName = line.substring(BEGIN_RESOURCE_START_STRING.length(), line.lastIndexOf(41));
        }
        if (line.startsWith("%%")) {
            return line;
        }
        if (line.contains(":")) {
            line = line.replace(":", "> <");
        }
        if (line.contains("=")) {
            line = line.replace("=", "> ");
        }
        return line;
    }

    String getCmapName() {
        return this.cmapName;
    }

    public void resetCmapReader() throws IOException {
        this.cmapEof = false;
        this.cmapName = null;
    }

    public boolean actualEof() {
        return this.actualEof;
    }

    @Override
    public void close() throws IOException {
    }
}

