/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.types.ASName;

public enum PDFFontStretch {
    ULTRA_CONDENSED(ASName.k_UltraCondensed),
    EXTRA_CONDENSED(ASName.k_ExtraCondensed),
    CONDENSED(ASName.k_Condensed),
    SEMI_CONDENSED(ASName.k_SemiCondensed),
    NORMAL(ASName.k_Normal),
    SEMI_EXPANDED(ASName.k_SemiExpanded),
    EXPANDED(ASName.k_Expanded),
    EXTRA_EXPANDED(ASName.k_ExtraExpanded),
    ULTRA_EXPANDED(ASName.k_UltraExpanded);

    private final ASName stretch;

    private PDFFontStretch(ASName stretch) {
        this.stretch = stretch;
    }

    public String toString() {
        return this.stretch.asString(true);
    }

    ASName getValue() {
        return this.stretch;
    }

    static final PDFFontStretch newInstance(ASName stretchValue) throws PDFInvalidParameterException {
        PDFFontStretch stretch = null;
        if (stretchValue == ASName.k_UltraCondensed) {
            stretch = ULTRA_CONDENSED;
        } else if (stretchValue == ASName.k_ExtraCondensed) {
            stretch = EXTRA_CONDENSED;
        } else if (stretchValue == ASName.k_Condensed) {
            stretch = CONDENSED;
        } else if (stretchValue == ASName.k_SemiCondensed) {
            stretch = SEMI_CONDENSED;
        } else if (stretchValue == ASName.k_Normal) {
            stretch = NORMAL;
        } else if (stretchValue == ASName.k_SemiExpanded) {
            stretch = SEMI_EXPANDED;
        } else if (stretchValue == ASName.k_Expanded) {
            stretch = EXPANDED;
        } else if (stretchValue == ASName.k_ExtraExpanded) {
            stretch = EXTRA_EXPANDED;
        } else if (stretchValue == ASName.k_UltraExpanded) {
            stretch = ULTRA_EXPANDED;
        } else {
            throw new PDFInvalidParameterException("illegal font stretch value");
        }
        return stretch;
    }
}

