/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import java.io.IOException;

public class PDFFontFile
extends PDFCosStream {
    public static final ASName k_Type1C = ASName.create("Type1C");
    public static final ASName k_CIDFontType0C = ASName.create("CIDFontType0C");
    public static final ASName k_OpenType = ASName.create("OpenType");

    private PDFFontFile(CosObject cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosStream);
    }

    public static PDFFontFile getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFontFile pdfObject = (PDFFontFile)PDFCosObject.getCachedInstance(cosObject, PDFFontFile.class);
        if (pdfObject == null) {
            pdfObject = new PDFFontFile(cosObject);
        }
        return pdfObject;
    }

    public static PDFFontFile newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream cosObject = PDFCosObject.newCosStream(pdfDocument);
        return new PDFFontFile(cosObject);
    }

    public static PDFFontFile newInstance(PDFDocument pdfDocument, InputByteStream stream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (stream == null) {
            return null;
        }
        PDFFontFile fontFile = PDFFontFile.newInstance(pdfDocument);
        try {
            fontFile.setStreamData(stream.toInputStream());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return fontFile;
    }

    public static PDFFontFile newInstance(PDFDocument pdfDoc, boolean opentypeOK, Font afeFont) throws PDFFontException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        try {
            if (!afeFont.canEmbedForEditting()) {
                return null;
            }
            OutputByteStream outStream = pdfDoc.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            afeFont.getPDFFontDescription().stream(outStream.toOutputStream(), opentypeOK);
            InputByteStream fontFileStream = outStream.closeAndConvert();
            outStream = null;
            PDFFontFile fontFile = PDFFontFile.newInstance(pdfDoc, fontFileStream);
            fontFileStream = null;
            return fontFile;
        }
        catch (FontEngineException e) {
            throw new PDFFontException(e);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public void setEmbeddedFontType(EmbeddedFontType fontType) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (fontType == null) {
            super.removeValue(ASName.k_Subtype);
        } else {
            super.setSubtype(fontType.getName());
        }
    }

    public EmbeddedFontType getEmbeddedFontType() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return EmbeddedFontType.getInstance(super.getSubtype());
    }

    public long getLength1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosStream().containsKey(ASName.k_Length1)) {
            return this.getCosStream().getLong(ASName.k_Length1);
        }
        return 0L;
    }

    public long getLength2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosStream().containsKey(ASName.k_Length2)) {
            return this.getCosStream().getLong(ASName.k_Length2);
        }
        return 0L;
    }

    public long getLength3() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosStream().containsKey(ASName.k_Length3)) {
            return this.getCosStream().getLong(ASName.k_Length3);
        }
        return 0L;
    }

    PDFMetadata getMetaData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosStream().containsKey(ASName.k_Metadata)) {
            return PDFMetadata.getInstance(this.getDictionaryCosObjectValue(ASName.k_Metadata));
        }
        return null;
    }

    public void setMetaData(CosStream metadata) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (metadata == null) {
            this.getCosStream().remove(ASName.k_Metadata);
        } else {
            this.setDictionaryValue(ASName.k_Metadata, metadata);
        }
    }

    public InputByteStream getStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosStream().getStreamDecoded();
    }

    public void setFilter(PDFFilterFlate filter) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFFilterList filterList = this.procureOutputFilters();
        filterList.add(filter);
        this.setOutputFilters(filterList);
    }

    public static enum EmbeddedFontType {
        Type1C(k_Type1C),
        CIDFontType0C(k_CIDFontType0C),
        OpenType(k_OpenType);

        private ASName name;

        private EmbeddedFontType(ASName name) {
            this.name = name;
        }

        public static EmbeddedFontType getInstance(ASName fontType) {
            if (fontType == k_Type1C) {
                return Type1C;
            }
            if (fontType == k_CIDFontType0C) {
                return CIDFontType0C;
            }
            if (fontType == k_OpenType) {
                return OpenType;
            }
            return null;
        }

        public String toString() {
            return this.name.asString();
        }

        public ASName getName() {
            return this.name;
        }
    }
}

