/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CIDSystemInfo;

public class PDFCIDSystemInfo
extends PDFCosDictionary
implements CIDSystemInfo {
    public static final String Ordering_Japan1 = "Japan1";
    public static final String Ordering_GB1 = "GB1";
    public static final String Ordering_Korea1 = "Korea1";
    public static final String Ordering_CNS1 = "CNS1";

    private PDFCIDSystemInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCIDSystemInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCIDSystemInfo pdfObject = (PDFCIDSystemInfo)PDFCosObject.getCachedInstance(cosObject, PDFCIDSystemInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFCIDSystemInfo(cosObject);
        }
        return pdfObject;
    }

    public static PDFCIDSystemInfo newInstance(PDFDocument pdfDocument, ASString registry, ASString ordering, int supplement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFCIDSystemInfo pdfObject = new PDFCIDSystemInfo(cosObject);
        pdfObject.setRegistry(registry);
        pdfObject.setOrdering(ordering);
        pdfObject.setSupplement(supplement);
        return pdfObject;
    }

    @Override
    public ASString getRegistry() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getCosDictionary().getString(ASName.k_Registry);
    }

    @Override
    public ASString getOrdering() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getCosDictionary().getString(ASName.k_Ordering);
    }

    @Override
    public int getSupplement() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getCosDictionary().getInt(ASName.k_Supplement);
    }

    public void setRegistry(ASString registry) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryASStringValue(ASName.k_Registry, registry);
    }

    public void setOrdering(ASString ordering) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryASStringValue(ASName.k_Ordering, ordering);
    }

    public void setSupplement(int supplement) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Supplement, supplement);
    }
}

