/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFColorSpaceWithTintTransform;

public class PDFColorSpaceSeparation
extends PDFColorSpaceWithTintTransform {
    private static final double[] defaultColor = new double[]{1.0};

    private PDFColorSpaceSeparation(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceSeparation getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceSeparation pdfObject = (PDFColorSpaceSeparation)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceSeparation.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceSeparation(cosObject);
        }
        return pdfObject;
    }

    @Override
    public ASName getName() {
        return ASName.k_Separation;
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    public ASName getColorantName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosArray().getName(1);
    }

    public void setColorantName(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (name == null) {
            throw new PDFInvalidParameterException("colorant name cannot be null");
        }
        this.getCosArray().setName(1, name);
    }

    @Override
    public double[] getDefaultColor() {
        return defaultColor;
    }
}

