/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFValueContainer;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFactory;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalfToneFactory;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftone;
import com.adobe.internal.pdftoolkit.pdf.transparency.PDFSoftMask;
import java.util.ArrayList;

public class PDFExtGState
extends PDFCosDictionary {
    private PDFExtGState(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFExtGState getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFExtGState pdfObject = (PDFExtGState)PDFCosObject.getCachedInstance(cosObject, PDFExtGState.class);
        if (pdfObject == null) {
            pdfObject = new PDFExtGState(cosObject);
        }
        return pdfObject;
    }

    public static PDFExtGState newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosDict = PDFCosObject.newCosDictionary(pdfDocument);
        cosDict.put(ASName.k_Type, ASName.k_ExtGState);
        return PDFExtGState.getInstance(cosDict);
    }

    public boolean hasLineWidth() {
        return this.getCosDictionary().containsKey(ASName.k_LW);
    }

    public double getLineWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getDouble(ASName.k_LW);
    }

    public boolean hasLineCap() {
        return this.getCosDictionary().containsKey(ASName.k_LC);
    }

    public int getLineCap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getInt(ASName.k_LC);
    }

    public boolean hasLineJoin() {
        return this.getCosDictionary().containsKey(ASName.k_LJ);
    }

    public int getLineJoin() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getInt(ASName.k_LJ);
    }

    public boolean hasMiterLimit() {
        return this.getCosDictionary().containsKey(ASName.k_ML);
    }

    public double getMiterLimit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getDouble(ASName.k_ML);
    }

    public boolean hasDashPattern() {
        return this.getCosDictionary().containsKey(ASName.k_D);
    }

    public CosArray getDashPattern() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getCosArray(ASName.k_D);
    }

    public boolean hasRenderingIntent() {
        return this.getCosDictionary().containsKey(ASName.k_RI);
    }

    public ASName getRenderingIntent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getName(ASName.k_RI);
    }

    public void setRenderingIntent(PDFRenderingIntent intent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_RI, intent.getValue());
    }

    public boolean hasOverprintStroke() {
        return this.getCosDictionary().containsKey(ASName.k_OP);
    }

    public boolean getOverprintStroke() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getBoolean(ASName.k_OP);
    }

    public boolean hasOverprintFill() {
        return this.getCosDictionary().containsKey(ASName.k_op);
    }

    public boolean getOverprintFill() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getBoolean(ASName.k_op);
    }

    public boolean hasOverprintMode() {
        return this.getCosDictionary().containsKey(ASName.k_OPM);
    }

    public int getOverprintMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getInt(ASName.k_OPM);
    }

    public boolean hasFont() {
        return this.getCosDictionary().containsKey(ASName.k_Font);
    }

    public PDFFontContainer getFontContainer() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray cosArray = this.getCosDictionary().getCosArray(ASName.k_Font);
        return new PDFFontContainer((PDFFont)PDFFontFactory.getInstance(cosArray.get(0)), cosArray.get(1).intValue());
    }

    public void setFontContainer(PDFFontContainer fontContainer) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(fontContainer.getFont());
        list.add(fontContainer.getSize());
        this.setDictionaryArrayValue(ASName.k_Font, PDFCosUtils.newCosArray(this.getPDFDocument(), list));
    }

    public boolean hasBGFunction() {
        return this.getCosDictionary().containsKey(ASName.k_BG) || this.getCosDictionary().containsKey(ASName.k_BG2);
    }

    public PDFValueContainer<PDFValueContainer.Type, Object> getBGFunction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj;
        CosObject cosObject = cosObj = this.getDictionaryValue(ASName.k_BG2) == null ? this.getDictionaryValue(ASName.k_BG) : null;
        if (cosObj instanceof CosDictionary) {
            return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.Function, PDFFunctionFactory.getInstance(cosObj));
        }
        if (cosObj instanceof CosName) {
            return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.Name, cosObj.nameValue());
        }
        return null;
    }

    public boolean isBGDefault() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasBGFunction()) {
            return true;
        }
        CosObject cosObj = this.getDictionaryValue(ASName.k_BG2);
        return !(cosObj != null ? !(cosObj instanceof CosName) || cosObj.nameValue() != ASName.k_Default : this.getCosDictionary().containsKey(ASName.k_BG));
    }

    public boolean hasUCRFunction() {
        return this.getCosDictionary().containsKey(ASName.k_UCR) || this.getCosDictionary().containsKey(ASName.k_UCR2);
    }

    public PDFValueContainer<PDFValueContainer.Type, Object> getUCRFunction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject ucr2 = this.getDictionaryValue(ASName.k_UCR2);
        if (ucr2 instanceof CosDictionary) {
            return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.Function, PDFFunctionFactory.getInstance(ucr2));
        }
        if (ucr2 instanceof CosName) {
            return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.Name, ucr2.nameValue());
        }
        CosObject ucr = this.getDictionaryValue(ASName.k_UCR);
        if (ucr instanceof CosDictionary) {
            return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.Function, PDFFunctionFactory.getInstance(ucr));
        }
        if (ucr instanceof CosName) {
            return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.Name, ucr.nameValue());
        }
        return null;
    }

    public boolean isUCRDefault() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasUCRFunction()) {
            return true;
        }
        CosObject cosObj = this.getDictionaryValue(ASName.k_UCR2);
        return !(cosObj != null ? !(cosObj instanceof CosName) || cosObj.nameValue() != ASName.k_Default : this.getCosDictionary().containsKey(ASName.k_UCR));
    }

    public boolean hasTransferFunction() {
        return this.getCosDictionary().containsKey(ASName.k_TR) || this.getCosDictionary().containsKey(ASName.k_TR2);
    }

    public boolean isTRIdentity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasTransferFunction()) {
            return true;
        }
        CosObject cosObjTR2 = this.getDictionaryValue(ASName.k_TR2);
        CosObject cosObjTR = this.getDictionaryValue(ASName.k_TR);
        return !(cosObjTR2 != null ? !(cosObjTR2 instanceof CosName) || cosObjTR2.nameValue() != ASName.k_Identity : cosObjTR != null && (!(cosObjTR instanceof CosName) || cosObjTR.nameValue() != ASName.k_Identity));
    }

    public PDFValueContainer<PDFValueContainer.Type, Object> getTransferFunction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj;
        CosObject cosObject = cosObj = this.getCosDictionary().get(ASName.k_TR2) == null ? this.getCosDictionary().get(ASName.k_TR) : null;
        if (cosObj != null) {
            int type = cosObj.getType();
            if (type == 3) {
                return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.Name, cosObj.nameValue());
            }
            if (type == 6) {
                return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.Function, PDFFunctionFactory.getInstance(cosObj));
            }
            if (type == 5) {
                CosArray array = (CosArray)cosObj;
                int size = array.size();
                PDFFunction[] functions = new PDFFunction[size];
                for (int i = 0; i < size; ++i) {
                    functions[i] = PDFFunctionFactory.getInstance(array.get(i));
                }
                return new PDFValueContainer<PDFValueContainer.Type, PDFFunction[]>(PDFValueContainer.Type.FunctionArray, functions);
            }
        }
        return null;
    }

    public boolean hasHalftone() {
        return this.getCosDictionary().containsKey(ASName.k_HT);
    }

    public PDFHalftone getHT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFHalfToneFactory.getInstance(this.getDictionaryValue(ASName.k_HT));
    }

    public boolean isHalftoneDefault() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasHalftone()) {
            return true;
        }
        CosObject cosObj = this.getDictionaryValue(ASName.k_HT);
        return cosObj instanceof CosName && cosObj.nameValue() == ASName.k_Default;
    }

    public boolean hasFlatness() {
        return this.getCosDictionary().containsKey(ASName.k_FL);
    }

    public double getFlatness() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getDouble(ASName.k_FL);
    }

    public boolean hasSmoothness() {
        return this.getCosDictionary().containsKey(ASName.k_SM);
    }

    public double getSmoothness() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getDouble(ASName.k_SM);
    }

    public boolean haStrokeAdjustment() {
        return this.getCosDictionary().containsKey(ASName.k_SA);
    }

    public boolean getStrokeAdjustment() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getBoolean(ASName.k_SA);
    }

    public boolean hasBlendMode() {
        return this.getCosDictionary().containsKey(ASName.k_BM);
    }

    public ASName[] getBlendMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj = this.getCosDictionary().get(ASName.k_BM);
        ASName[] asNames = null;
        if (cosObj instanceof CosArray) {
            CosArray array = (CosArray)cosObj;
            int size = array.size();
            asNames = new ASName[size];
            for (int i = 0; i < size; ++i) {
                asNames[i] = array.getName(i);
            }
        } else if (cosObj instanceof CosName) {
            asNames = new ASName[]{cosObj.nameValue()};
        }
        return asNames;
    }

    public void setBlendMode(ASName blendMode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_BM, blendMode);
    }

    public boolean isBMNormal() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasBlendMode()) {
            return true;
        }
        CosObject cosObj = this.getDictionaryValue(ASName.k_BM);
        return cosObj instanceof CosName && cosObj.nameValue() == ASName.k_Normal;
    }

    public boolean hasSoftMask() {
        return this.getCosDictionary().containsKey(ASName.k_SMask);
    }

    public Boolean isSoftMaskDictionary() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosObject cosObj = this.getCosDictionary().get(ASName.k_SMask);
        if (cosObj != null) {
            if (cosObj instanceof CosDictionary) {
                return true;
            }
            if (cosObj instanceof CosName) {
                return false;
            }
            throw new PDFInvalidDocumentException("Soft mask should either be a name or dictionary.");
        }
        return null;
    }

    public PDFValueContainer<PDFValueContainer.Type, Object> getSoftMask() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosObject cosObj = this.getCosDictionary().get(ASName.k_SMask);
        if (cosObj != null) {
            int type = cosObj.getType();
            if (type == 6) {
                return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.SoftMask, PDFSoftMask.getInstance(cosObj));
            }
            if (type == 3) {
                return new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.Name, cosObj.nameValue());
            }
        }
        return null;
    }

    public void setSoftMask(PDFSoftMask softMask) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.setDictionaryValue(ASName.k_SMask, softMask);
    }

    public void setSoftMask(ASName softMask) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.setDictionaryNameValue(ASName.k_SMask, softMask);
    }

    public boolean isSoftMaskNone() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasSoftMask()) {
            return true;
        }
        CosObject cosObj = this.getDictionaryValue(ASName.k_SMask);
        return cosObj instanceof CosName && cosObj.nameValue() == ASName.k_None;
    }

    public boolean hasOpacityStroke() {
        return this.getCosDictionary().containsKey(ASName.k_CA);
    }

    public double getOpacityStroke() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getDouble(ASName.k_CA);
    }

    public void setOpacityStroke(double opacity) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_CA, opacity);
    }

    public boolean hasOpacityFill() {
        return this.getCosDictionary().containsKey(ASName.k_ca);
    }

    public double getOpacityFill() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getDouble(ASName.k_ca);
    }

    public void setOpacityFill(double opacity) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_ca, opacity);
    }

    public boolean hasAlphaSource() {
        return this.getCosDictionary().containsKey(ASName.k_AIS);
    }

    public boolean getAlphaSource() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getBoolean(ASName.k_AIS);
    }

    public boolean hasTextKnockout() {
        return this.getCosDictionary().containsKey(ASName.k_TK);
    }

    public boolean getTextKnockout() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getBoolean(ASName.k_TK);
    }

    public PDFHalftone getHalfTone() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFHalfToneFactory.getInstance(this.getDictionaryCosObjectValue(ASName.k_HT));
    }

    public void setHT(PDFHalftone value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_HT, value);
    }

    public ASName getHTAsName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_HT);
    }

    public void setHT(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_HT, value);
    }

    public PDFStream getHTAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_HT);
        return PDFStream.getInstance(cosObject);
    }

    public void setHT(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_HT, value);
    }

    public boolean hasHT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_HT);
    }

    public ASName getUseBlackPTComp() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName useBlackPTComp = this.getCosDictionary().getName(ASName.k_UseBlackPTComp);
        if (useBlackPTComp == null) {
            return ASName.k_Default;
        }
        return useBlackPTComp;
    }

    public void setUseBlackPTComp(ASName useBlackPTComp) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (useBlackPTComp == ASName.k_ON || useBlackPTComp == ASName.k_OFF || useBlackPTComp == ASName.k_Default) {
            this.setDictionaryNameValue(ASName.k_UseBlackPTComp, useBlackPTComp);
        }
    }

    public static class PDFFontContainer {
        PDFFont font;
        Integer size;

        public PDFFontContainer(PDFFont font, Integer size) {
            this.font = font;
            this.size = size;
        }

        public PDFFont getFont() {
            return this.font;
        }

        public Integer getSize() {
            return this.size;
        }
    }
}

