/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.filters;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterParamData;
import java.util.Map;

public class PDFFilterParams
extends PDFCosDictionaryMap<PDFFilterParamData> {
    private PDFFilterParams(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFilterParams getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFilterParams pdfObject = (PDFFilterParams)PDFCosObject.getCachedInstance(cosObject, PDFFilterParams.class);
        if (pdfObject == null) {
            pdfObject = new PDFFilterParams(cosObject);
        }
        return pdfObject;
    }

    public static PDFFilterParams newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        return new PDFFilterParams(cosObject);
    }

    public static PDFFilterParams newInstance(PDFDocument pdfDocument, Map map) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (map == null) {
            return PDFFilterParams.newInstance(pdfDocument);
        }
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument, map);
        return new PDFFilterParams(cosObject);
    }

    @Override
    protected PDFFilterParamData itemInstantiator(CosObject cosObject) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return PDFFilterParamData.getInstance(cosObject);
    }

    public PDFFilterParamData get(String key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return (PDFFilterParamData)this.get(ASName.create(key));
    }

    @Override
    public void put(String key, boolean value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.create(key), value);
    }

    @Override
    public void put(String key, int value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.create(key), value);
    }

    @Override
    public void put(String key, double value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.create(key), value);
    }

    @Override
    public void put(String key, double[] value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.create(key), value);
    }

    @Override
    public void put(String key, String value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.create(key), ASName.create(value));
    }

    @Override
    public void put(String key, InputByteStream value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.create(key), this.getCosDictionary().getDocument().createCosStream(value));
    }
}

