/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;

public class PDFCosNumeric
extends PDFCosObject {
    private PDFCosNumeric(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("CosNumeric expected");
        }
    }

    public static PDFCosNumeric getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCosNumeric pdfObject = (PDFCosNumeric)PDFCosObject.getCachedInstance(cosObject, PDFCosNumeric.class);
        if (pdfObject == null) {
            pdfObject = new PDFCosNumeric(cosObject);
        }
        return pdfObject;
    }

    public int intValue() {
        if (!(this.getCosObject() instanceof CosNumeric)) {
            return 0;
        }
        return ((CosNumeric)this.getCosObject()).intValue();
    }

    public int fixedValue() throws PDFCosParseException {
        if (!(this.getCosObject() instanceof CosNumeric)) {
            return 0;
        }
        return ((CosNumeric)this.getCosObject()).fixedValue();
    }

    public long longValue() {
        if (!(this.getCosObject() instanceof CosNumeric)) {
            return 0L;
        }
        return ((CosNumeric)this.getCosObject()).longValue();
    }

    public double doubleValue() {
        if (!(this.getCosObject() instanceof CosNumeric)) {
            return 0.0;
        }
        return ((CosNumeric)this.getCosObject()).doubleValue();
    }

    public Number numberValue() {
        if (!(this.getCosObject() instanceof CosNumeric)) {
            return null;
        }
        return ((CosNumeric)this.getCosObject()).numberValue();
    }

    public Object getValue() {
        if (!(this.getCosObject() instanceof CosNumeric)) {
            return null;
        }
        return ((CosNumeric)this.getCosObject()).getValue();
    }
}

