/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class PDFCosDictionaryMap<V extends PDFCosObjectContainer>
extends PDFCosDictionary
implements Map<ASName, V> {
    protected PDFCosDictionaryMap(CosObject cosDict) throws PDFInvalidDocumentException {
        super(cosDict);
    }

    protected abstract V itemInstantiator(CosObject var1) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException;

    @Override
    public int size() {
        return this.getCosDictionary().size();
    }

    @Override
    public void clear() {
        try {
            this.getCosDictionary().clear();
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getCosDictionary().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("PDFCosDictionaryMap:containsKey Key cannot be null");
        }
        return this.getCosDictionary().containsKey(key);
    }

    private ASName getKeyForValue(Object value, String method) {
        try {
            if (value == null) {
                throw new IllegalArgumentException(method + ": value cannot be null");
            }
            if (value instanceof CosObject) {
                return this.getCosDictionary().getKeyForValue((CosObject)value);
            }
            if (value instanceof PDFCosObject) {
                return this.getCosDictionary().getKeyForValue(((PDFCosObject)value).getCosObject());
            }
            throw new ClassCastException(method + ": value is not of CosObject or PDFCosObject");
        }
        catch (PDFException pDFException) {
            return null;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getKeyForValue(value, "PDFCosDictionaryMap.containsValue") != null;
    }

    @Override
    public Collection values() {
        return new AbstractEntryValuesSet<Object>(){
            private Set<PDFCosDictMapEntry> entrySet;
            {
                this.entrySet = PDFCosDictionaryMap.this.entrySet();
            }

            @Override
            public void clear() {
                this.entrySet.clear();
            }

            @Override
            public boolean contains(Object o) {
                return PDFCosDictionaryMap.this.containsValue(o);
            }

            @Override
            public boolean isEmpty() {
                return this.entrySet.isEmpty();
            }

            @Override
            public Iterator<Object> iterator() {
                final Iterator<PDFCosDictMapEntry> it = this.entrySet.iterator();
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Object next() {
                        return ((PDFCosDictMapEntry)it.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                ASName key = PDFCosDictionaryMap.this.getKeyForValue(o, "PDFCosDictionaryMap.ValueSet.remove");
                if (key != null) {
                    try {
                        return PDFCosDictionaryMap.this.getCosDictionary().remove(key) != null;
                    }
                    catch (PDFException pDFException) {
                        // empty catch block
                    }
                }
                return false;
            }

            @Override
            public int size() {
                return this.entrySet.size();
            }
        };
    }

    @Override
    public void putAll(Map<? extends ASName, ? extends V> t) {
        for (Map.Entry<ASName, V> entry : t.entrySet()) {
            this.put(entry.getKey(), (V)((PDFCosObjectContainer)entry.getValue()));
        }
    }

    @Override
    public Set entrySet() {
        return new AbstractEntryValuesSet<PDFCosDictMapEntry>(){

            @Override
            public void clear() {
                try {
                    PDFCosDictionaryMap.this.getCosDictionary().clear();
                }
                catch (PDFException pDFException) {
                    // empty catch block
                }
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof PDFCosDictMapEntry) {
                    return PDFCosDictionaryMap.this.getCosDictionary().containsKey(((PDFCosDictMapEntry)o).getKey());
                }
                return false;
            }

            @Override
            public boolean isEmpty() {
                return PDFCosDictionaryMap.this.getCosDictionary().isEmpty();
            }

            @Override
            public Iterator<PDFCosDictMapEntry> iterator() {
                return new Iterator<PDFCosDictMapEntry>(){
                    private CosContainerValuesIterator it;
                    {
                        this.it = PDFCosDictionaryMap.this.getCosDictionary().getValuesIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public PDFCosDictMapEntry next() {
                        try {
                            return new PDFCosDictMapEntry(this.it.next());
                        }
                        catch (PDFException e) {
                            NoSuchElementException e1 = new NoSuchElementException();
                            e1.initCause(e);
                            throw e1;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove not supported");
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof PDFCosDictMapEntry) {
                    try {
                        return PDFCosDictionaryMap.this.getCosDictionary().remove(((PDFCosDictMapEntry)o).getKey()) != null;
                    }
                    catch (PDFException pDFException) {
                        // empty catch block
                    }
                }
                return false;
            }

            @Override
            public int size() {
                return PDFCosDictionaryMap.this.getCosDictionary().size();
            }
        };
    }

    @Override
    public Set<ASName> keySet() {
        return this.getCosDictionary().keySet();
    }

    @Override
    public V get(Object key) {
        try {
            if (key == null) {
                throw new IllegalArgumentException("PDFCosDictionaryMap.get: key cannot be null");
            }
            if (key instanceof ASName) {
                CosObject cosObj = this.getCosDictionary().get((ASName)key);
                return this.itemInstantiator(cosObj);
            }
            throw new ClassCastException("PDFCosDictionaryMap.get: key is not of type ASName");
        }
        catch (PDFException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public V remove(Object key) {
        try {
            if (key == null) {
                throw new IllegalArgumentException("PDFCosDictionaryMap.remove: key cannot be null");
            }
            if (key instanceof ASName) {
                return this.itemInstantiator(this.getCosDictionary().remove((ASName)key));
            }
            throw new ClassCastException("PDFCosDictionaryMap.remove: key is not of type ASName");
        }
        catch (PDFException pDFException) {
            return null;
        }
    }

    @Override
    public V put(ASName key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("PDFCosDictionaryMap.put: key or value cannot be null");
        }
        try {
            Object retVal = null;
            if (this.containsKey(key)) {
                retVal = this.get(key);
            }
            this.setDictionaryValue(key, value.getPDFCosObject());
            return (V)retVal;
        }
        catch (PDFException e) {
            throw new IllegalArgumentException("PDFCosDictionaryMap.put: Unable to put key:" + key + "/value:" + value + " into the map", e);
        }
    }

    protected class PDFCosDictMapEntry
    implements Map.Entry<ASName, V> {
        private final CosContainerValuesIterator.Entry entry;

        protected PDFCosDictMapEntry(CosContainerValuesIterator.Entry cosEntry) {
            this.entry = cosEntry;
        }

        @Override
        public ASName getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            try {
                return PDFCosDictionaryMap.this.itemInstantiator(this.entry.getValue());
            }
            catch (PDFException pDFException) {
                return null;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof PDFCosDictMapEntry) {
                return ((PDFCosDictMapEntry)o).getKey() == this.getKey() && ((PDFCosDictMapEntry)o).getValue() == this.getValue();
            }
            return false;
        }

        @Override
        public V setValue(V value) {
            return PDFCosDictionaryMap.this.put(this.entry.getKey(), value);
        }
    }

    private abstract class AbstractEntryValuesSet<T>
    implements Set<T> {
        private AbstractEntryValuesSet() {
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException("Value/Entry Sets of Maps do not have this supported");
        }

        @Override
        public boolean addAll(Collection<? extends T> o) {
            throw new UnsupportedOperationException("Value/Entry Sets of Maps do not have this supported");
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            for (Object o : coll) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            boolean retVal = false;
            for (Object o : coll) {
                retVal |= this.remove(o);
            }
            return retVal;
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            boolean retVal = false;
            ArrayList toBeRemovedItems = new ArrayList();
            for (Object entry : this) {
                if (coll.contains(entry)) continue;
                toBeRemovedItems.add(entry);
            }
            for (Object item : toBeRemovedItems) {
                retVal |= this.remove(item);
            }
            return retVal;
        }

        @Override
        public Object[] toArray() {
            Object[] objects = new Object[this.size()];
            return this.toArray(objects);
        }

        @Override
        public Object[] toArray(Object[] objects) {
            if (objects.length < this.size()) {
                objects = (Object[])Array.newInstance(objects.getClass().getComponentType(), this.size());
            }
            int i = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                objects[i++] = it.next();
            }
            return objects;
        }
    }
}

