/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldAction;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParameters;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFTransformParametersFieldMDP
extends PDFTransformParameters {
    private PDFTransformParametersFieldMDP(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    static PDFTransformParametersFieldMDP getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTransformParametersFieldMDP pdfObject = (PDFTransformParametersFieldMDP)PDFCosObject.getCachedInstance(cosObject, PDFTransformParametersFieldMDP.class);
        if (pdfObject == null) {
            pdfObject = new PDFTransformParametersFieldMDP(cosObject);
        }
        return pdfObject;
    }

    public static PDFTransformParametersFieldMDP newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFTransformParametersFieldMDP pdfObject = new PDFTransformParametersFieldMDP(cosObject);
        pdfObject.setAction(PDFFieldAction.All);
        pdfObject.setVersion("1.2");
        pdfObject.setType();
        return pdfObject;
    }

    public PDFFieldAction getAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldAction.getInstance(this.getDictionaryNameValue(ASName.k_Action));
    }

    public void setAction(PDFFieldAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (action == null) {
            throw new PDFInvalidDocumentException("Invalid Parameter:action entry can not be null");
        }
        this.setDictionaryNameValue(ASName.k_Action, action.getValue());
    }

    public String[] getFieldNames() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] names = null;
        CosArray cosNames = this.getDictionaryArrayValue(ASName.k_Fields);
        if (cosNames != null) {
            int count = cosNames.size();
            names = new String[count];
            for (int i = 0; i < count; ++i) {
                names[i] = cosNames.getText(i);
            }
        }
        return names;
    }

    public void setFieldNames(String[] fieldNames) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (fieldNames == null || fieldNames.length == 0) {
            throw new PDFInvalidDocumentException("Invalid Parameter: fields entry can not be null");
        }
        CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
        this.setDictionaryArrayValue(ASName.k_Fields, cosArray);
        int addAtIndex = 0;
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i] == null) continue;
            cosArray.addText(addAtIndex++, fieldNames[i]);
        }
    }
}

