/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSubjectDN;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PDFSubjectDNList
extends PDFCosArrayList<PDFSubjectDN> {
    private PDFSubjectDNList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSubjectDNList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSubjectDNList pdfObject = (PDFSubjectDNList)PDFCosObject.getCachedInstance(cosObject, PDFSubjectDNList.class);
        if (pdfObject == null) {
            pdfObject = new PDFSubjectDNList(cosObject);
        }
        return pdfObject;
    }

    public static PDFSubjectDNList newInstance(PDFDocument pdfDocument, List<Map> dnMaps) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFSubjectDNList pdfObject = new PDFSubjectDNList(cosObject);
        if (dnMaps != null) {
            for (Map dnMap : dnMaps) {
                Iterator attrIter = dnMap.entrySet().iterator();
                PDFSubjectDN subjectDN = PDFSubjectDN.newInstance(pdfDocument);
                while (attrIter.hasNext()) {
                    Map.Entry pairs = attrIter.next();
                    subjectDN.setAttributeValue((String)pairs.getKey(), (String)pairs.getValue());
                }
                pdfObject.add(subjectDN);
            }
        }
        return pdfObject;
    }

    @Override
    public PDFSubjectDN itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFSubjectDN.getInstance(cosObject);
    }

    public SubjectDNArrayListIterator getIterator() {
        return new SubjectDNArrayListIterator(this);
    }

    public PDFSubjectDN[] toArray() {
        return (PDFSubjectDN[])this.toArray(new PDFSubjectDN[0]);
    }

    public class SubjectDNArrayListIterator {
        Iterator<PDFSubjectDN> subjectDNIter;

        SubjectDNArrayListIterator(PDFSubjectDNList subjectDNList) {
            this.subjectDNIter = subjectDNList.iterator();
        }

        public boolean hasNext() {
            return this.subjectDNIter.hasNext();
        }

        public PDFSubjectDN next() {
            return this.subjectDNIter.next();
        }

        public void remove() throws PDFUnsupportedFeatureException {
            throw new PDFUnsupportedFeatureException("Cannot remove subjectDN entries");
        }
    }
}

