/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReference;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFSignatureReferenceList
extends PDFCosArrayList<PDFSignatureReference> {
    private PDFSignatureReferenceList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSignatureReferenceList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSignatureReferenceList pdfObject = (PDFSignatureReferenceList)PDFCosObject.getCachedInstance(cosObject, PDFSignatureReferenceList.class);
        if (pdfObject == null) {
            pdfObject = new PDFSignatureReferenceList(cosObject);
        }
        return pdfObject;
    }

    public static PDFSignatureReferenceList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFSignatureReferenceList(cosObject);
    }

    @Override
    protected PDFSignatureReference itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        return PDFSignatureReference.getInstance(cosObject);
    }
}

