/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;

public class PDFLegalAttestation
extends PDFCosDictionary {
    public static final ASName k_JavaScriptActions = ASName.create("JavaScriptActions");
    public static final ASName k_LaunchActions = ASName.create("LaunchActions");
    public static final ASName k_URIActions = ASName.create("URIActions");
    public static final ASName k_MovieActions = ASName.create("MovieActions");
    public static final ASName k_SoundActions = ASName.create("SoundActions");
    public static final ASName k_HideAnnotationActions = ASName.create("HideAnnotationActions");
    public static final ASName k_RenditionActions = ASName.create("RenditionActions");
    public static final ASName k_GoToRemoteActions = ASName.create("GoToRemoteActions");
    public static final ASName k_AlternateImages = ASName.create("AlternateImages");
    public static final ASName k_ExternalStreams = ASName.create("ExternalStreams");
    public static final ASName k_TrueTypeFonts = ASName.create("TrueTypeFonts");
    public static final ASName k_ExternalRefXobjects = ASName.create("ExternalRefXobjects");
    public static final ASName k_ExternalOPIdicts = ASName.create("ExternalOPIdicts");
    public static final ASName k_NonEmbeddedFonts = ASName.create("NonEmbeddedFonts");
    public static final ASName k_DevDepGS_OP = ASName.create("DevDepGS_OP");
    public static final ASName k_DevDepGS_HT = ASName.create("DevDepGS_HT");
    public static final ASName k_DevDepGS_TR = ASName.create("DevDepGS_TR");
    public static final ASName k_DevDepGS_UCR = ASName.create("DevDepGS_UCR");
    public static final ASName k_DevDepGS_BG = ASName.create("DevDepGS_BG");
    public static final ASName k_DevDepGS_FL = ASName.create("DevDepGS_FL");
    public static final ASName k_Annotations = ASName.create("Annotations");
    public static final ASName k_OptionalContent = ASName.create("OptionalContent");
    public static final ASName k_Attestation = ASName.create("Attestation");

    private PDFLegalAttestation(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFLegalAttestation getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFLegalAttestation pdfObject = (PDFLegalAttestation)PDFCosObject.getCachedInstance(cosObject, PDFLegalAttestation.class);
        if (pdfObject == null) {
            pdfObject = new PDFLegalAttestation(cosObject);
        }
        return pdfObject;
    }

    public static PDFLegalAttestation newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFLegalAttestation pdfObject = new PDFLegalAttestation(cosObject);
        return pdfObject;
    }

    private int getLegalAttestationCounter(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(key)) {
            return this.getDictionaryIntValue(key);
        }
        return 0;
    }

    public int getJavaScriptActionCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_JavaScriptActions);
    }

    public void setJavaScriptActionCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_JavaScriptActions);
        } else {
            this.setDictionaryIntValue(k_JavaScriptActions, count);
        }
    }

    public int getLaunchActionsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_LaunchActions);
    }

    public void setLaunchActionsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_LaunchActions);
        } else {
            this.setDictionaryIntValue(k_LaunchActions, count);
        }
    }

    public int getURIActionsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_URIActions);
    }

    public void setURIActionsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_URIActions);
        } else {
            this.setDictionaryIntValue(k_URIActions, count);
        }
    }

    public int getMovieActionsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_MovieActions);
    }

    public void setMovieActionsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_MovieActions);
        } else {
            this.setDictionaryIntValue(k_MovieActions, count);
        }
    }

    public int getSoundActionsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_SoundActions);
    }

    public void setSoundActionsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_SoundActions);
        } else {
            this.setDictionaryIntValue(k_SoundActions, count);
        }
    }

    public int getHideAnnotationActionsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_HideAnnotationActions);
    }

    public void setHideAnnotationActionsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_HideAnnotationActions);
        } else {
            this.setDictionaryIntValue(k_HideAnnotationActions, count);
        }
    }

    public int getRenditionActionsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_RenditionActions);
    }

    public void setRenditionActionsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_RenditionActions);
        } else {
            this.setDictionaryIntValue(k_RenditionActions, count);
        }
    }

    public int getGoToRemoteCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_GoToRemoteActions);
    }

    public void setGoToRemoteCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_GoToRemoteActions);
        } else {
            this.setDictionaryIntValue(k_GoToRemoteActions, count);
        }
    }

    public int getAlternateImagesCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_AlternateImages);
    }

    public void setAlternateImagesCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_AlternateImages);
        } else {
            this.setDictionaryIntValue(k_AlternateImages, count);
        }
    }

    public int getExternalStreamsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_ExternalStreams);
    }

    public void setExternalStreamsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_ExternalStreams);
        } else {
            this.setDictionaryIntValue(k_ExternalStreams, count);
        }
    }

    public int getTrueTypeFontsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_TrueTypeFonts);
    }

    public void setTrueTypeFontsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_TrueTypeFonts);
        } else {
            this.setDictionaryIntValue(k_TrueTypeFonts, count);
        }
    }

    public int getExternalRefXobjectsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_ExternalRefXobjects);
    }

    public void setExternalRefXobjectsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_ExternalRefXobjects);
        } else {
            this.setDictionaryIntValue(k_ExternalRefXobjects, count);
        }
    }

    public int getExternalOPIdictsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_ExternalOPIdicts);
    }

    public void setExternalOPIdictsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_ExternalOPIdicts);
        } else {
            this.setDictionaryIntValue(k_ExternalOPIdicts, count);
        }
    }

    public int getNonEmbeddedFontsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_NonEmbeddedFonts);
    }

    public void setNonEmbeddedFontsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_NonEmbeddedFonts);
        } else {
            this.setDictionaryIntValue(k_NonEmbeddedFonts, count);
        }
    }

    public int getDevDepGS_OPCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_DevDepGS_OP);
    }

    public void setDevDepGS_OPCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_DevDepGS_OP);
        } else {
            this.setDictionaryIntValue(k_DevDepGS_OP, count);
        }
    }

    public int getDevDepGS_HTCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_DevDepGS_HT);
    }

    public void setDevDepGS_HTCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_DevDepGS_HT);
        } else {
            this.setDictionaryIntValue(k_DevDepGS_HT, count);
        }
    }

    public int getDevDepGS_TRCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_DevDepGS_TR);
    }

    public void setDevDepGS_TRCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_DevDepGS_TR);
        } else {
            this.setDictionaryIntValue(k_DevDepGS_TR, count);
        }
    }

    public int getDevDepGS_UCRCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_DevDepGS_UCR);
    }

    public void setDevDepGS_UCRCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_DevDepGS_UCR);
        } else {
            this.setDictionaryIntValue(k_DevDepGS_UCR, count);
        }
    }

    public int getDevDepGS_BGCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_DevDepGS_BG);
    }

    public void setDevDepGS_BGCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_DevDepGS_BG);
        } else {
            this.setDictionaryIntValue(k_DevDepGS_BG, count);
        }
    }

    public int getDevDepGS_FLCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_DevDepGS_FL);
    }

    public void setDevDepGS_FLCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_DevDepGS_FL);
        } else {
            this.setDictionaryIntValue(k_DevDepGS_FL, count);
        }
    }

    public int getAnnotationsCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getLegalAttestationCounter(k_Annotations);
    }

    public void setAnnotationsCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (count == 0) {
            this.removeValue(k_Annotations);
        } else {
            this.setDictionaryIntValue(k_Annotations, count);
        }
    }

    public boolean getOptionalContentFound() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_OptionalContent)) {
            CosObject value = this.getDictionaryValue(k_OptionalContent);
            if (value.getType() == 2) {
                return value.booleanValue();
            }
            return true;
        }
        return false;
    }

    public void setOptionalContentFound(boolean ocFoundInDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!ocFoundInDoc) {
            this.removeValue(k_OptionalContent);
        } else {
            this.setDictionaryBooleanValue(k_OptionalContent, ocFoundInDoc);
        }
    }

    public String getAttestation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_Attestation)) {
            return this.getDictionaryTextStringValue(k_Attestation);
        }
        return null;
    }

    public void setAttestation(String attestation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Attestation, attestation);
    }

    public void setAttestation(String attestation, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Attestation, attestation, unicode);
    }
}

