/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.contentmodify;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.io.IOException;
import java.util.Map;

public class ModifiableContent
extends Content {
    private static final String xFormName = "Fm";
    private static final String xImageName = "Im";

    private ModifiableContent(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
    }

    private ModifiableContent(PDFContents contents, boolean contentDetached, PDFResources resources, boolean resourcesDetached) {
        super(contents, contentDetached, resources, resourcesDetached);
    }

    public static ModifiableContent newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new ModifiableContent(pdfDocument);
    }

    public static ModifiableContent newInstance(PDFContents contents, PDFResources resources) {
        return new ModifiableContent(contents, false, resources, false);
    }

    public ASName addResource(PDFColorSpace colorspace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String baseName = "Cs";
        PDFColorSpaceMap map = this.resources.procureColorSpaceMap();
        return this.procureResourceName(map, colorspace, baseName);
    }

    public ASName addResource(PDFExtGState extGState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String baseName = "GS";
        PDFExtGStateMap map = this.resources.procureExtGStateMap();
        return this.procureResourceName(map, extGState, baseName);
    }

    public ASName addResource(PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String baseName = "F";
        PDFFontMap map = this.resources.procureFontMap();
        return this.procureResourceName(map, font, baseName);
    }

    public ASName addResource(PDFMCProperty property) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String baseName = "P";
        PDFMCPropertyMap map = this.resources.procureMCPropertyMap();
        return this.procureResourceName(map, property, baseName);
    }

    public ASName addResource(PDFPattern pattern) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String baseName = "P";
        PDFPatternMap map = this.resources.procurePatternMap();
        return this.procureResourceName(map, pattern.getPDFCosObject(), baseName);
    }

    public ASName addResource(PDFShading shading) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String baseName = "Sh";
        PDFShadingMap map = this.resources.procureShadingMap();
        return this.procureResourceName(map, shading.getPDFCosObject(), baseName);
    }

    public ASName addResource(PDFXObject pdfXObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String baseName = null;
        if (pdfXObject instanceof PDFXObjectForm) {
            baseName = xFormName;
        } else if (pdfXObject instanceof PDFXObjectImage) {
            baseName = xImageName;
        }
        PDFXObjectMap map = this.resources.procureXObjectMap();
        return this.procureResourceName(map, pdfXObject, baseName);
    }

    ASName addResource(PDFXObjectImage xObjectImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String baseName = xImageName;
        PDFXObjectMap map = this.resources.procureXObjectMap();
        return this.procureResourceName(map, xObjectImage, baseName);
    }

    public static ModifiableContent getInstance(PDFContents contents, PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new ModifiableContent(contents, false, resources, false);
    }

    public static ModifiableContent newInstance(PDFPatternTiling pattern) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFContents contents = pattern.getContents();
        PDFResources resources = pattern.getResources();
        boolean contentDetached = false;
        boolean resourcesDetached = false;
        if (contents == null) {
            contents = PDFContents.newInstance(pattern.getPDFDocument());
            contentDetached = true;
        }
        if (resources == null) {
            resources = PDFResources.newInstance(pattern.getPDFDocument());
            resourcesDetached = true;
        }
        return new ModifiableContent(contents, contentDetached, resources, resourcesDetached);
    }

    public static ModifiableContent newInstance(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFContents contents = page.getContents();
        PDFResources resources = page.getResources();
        boolean contentDetached = false;
        boolean resourcesDetached = false;
        if (contents == null) {
            contents = PDFContents.newInstance(page.getPDFDocument());
            contentDetached = true;
        }
        if (resources == null) {
            resources = PDFResources.newInstance(page.getPDFDocument());
            resourcesDetached = true;
        }
        return new ModifiableContent(contents, contentDetached, resources, resourcesDetached);
    }

    public static ModifiableContent newInstance(PDFXObjectForm xobjectForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFContents contents = xobjectForm.getContents();
        PDFResources resources = xobjectForm.getResources();
        boolean contentDetached = false;
        boolean resourcesDetached = false;
        if (contents == null) {
            contents = PDFContents.newInstance(xobjectForm.getPDFDocument());
            contentDetached = true;
        }
        if (resources == null) {
            resources = PDFResources.newInstance(xobjectForm.getPDFDocument());
            resourcesDetached = true;
        }
        return new ModifiableContent(contents, contentDetached, resources, resourcesDetached);
    }

    public static ModifiableContent newInstance(PDFDefaultAppearance defaultAppearance) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException {
        try {
            if (defaultAppearance == null) {
                return null;
            }
            byte[] bytes = defaultAppearance.asByteArray();
            if (bytes != null) {
                PDFResources resources;
                PDFDocument pdfDocument = defaultAppearance.getPDFDocument();
                boolean contentDetached = false;
                boolean resourcesDetached = false;
                PDFContents contents = PDFContents.newInstance(pdfDocument);
                contents.setContents(defaultAppearance.getStreamManager().getInputByteStream(bytes));
                PDFInteractiveForm acroForm = pdfDocument.requireCatalog().getInteractiveForm();
                if (acroForm != null) {
                    resources = acroForm.getResources();
                } else {
                    resources = PDFResources.newInstance(pdfDocument);
                    resourcesDetached = true;
                }
                return new ModifiableContent(contents, contentDetached, resources, resourcesDetached);
            }
            return null;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private ASName procureResourceName(PDFCosDictionaryMap resourceMap, PDFCosObject resource, String baseName) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        ASName resourceName = ModifiableContent.getExistingResourceName(resourceMap, resource.getCosObject());
        if (resourceName == null) {
            resourceName = this.makeResourceName(resourceMap, baseName);
            resourceMap.put(resourceName, resource);
        }
        return resourceName;
    }

    private static ASName getExistingResourceName(PDFCosDictionaryMap resourceMap, CosObject resource) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosDict = resourceMap.getCosDictionary();
        return cosDict.getKeyForValue(resource);
    }

    private ASName makeResourceName(Map map, String baseName) {
        int i = 0;
        ASName resourceName = null;
        while (map.containsKey(resourceName = ASName.create(baseName + Integer.toString(++i)))) {
        }
        return resourceName;
    }

    public void setContents(PDFContents contents) {
        this.contents = contents;
    }
}

