/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ActualText;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextRun;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextRunList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.MissingResourceException;

public class TextObject {
    private boolean ignoreErrors;
    private TextRunList textRuns = new TextRunList();
    private ASMatrix tm = ASMatrix.createIdentityMatrix();
    private ASMatrix tlm = ASMatrix.createIdentityMatrix();
    private ASMatrix trm = ASMatrix.createIdentityMatrix();
    private PDFDocument pdfDocument;
    private boolean skipThisTextObject = false;

    public TextObject(PDFDocument pdfDocument, boolean ignoreErrors) {
        this.pdfDocument = pdfDocument;
        this.ignoreErrors = ignoreErrors;
    }

    public TextObject(TextObject textObj, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfDocument = textObj.pdfDocument;
        this.ignoreErrors = ignoreErrors;
        this.textRuns = new TextRunList(textObj.getTextRuns());
        this.tm = textObj.getTextMatrix();
        this.tlm = textObj.getTextLineMatrix();
        this.trm = textObj.getTextRenderingMatrix();
    }

    public TextRunList getTextRuns() {
        return this.textRuns;
    }

    public void addTextRun(ASString string, GState gState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (string.getBytes() != null && string.getBytes().length != 0) {
                TextRun textRun = new TextRun(string, this.tm, gState, this.pdfDocument, this.ignoreErrors);
                this.textRuns.add(textRun);
                this.adjustTextMatrix(textRun);
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (PDFInvalidDocumentException pDFInvalidDocumentException) {
            // empty catch block
        }
    }

    public void addTextRun(ASString string, GState gState, ActualText actualText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (string.getBytes() != null && string.getBytes().length != 0) {
                TextRun textRun = new TextRun(string, this.tm, gState, actualText, this.pdfDocument, this.ignoreErrors);
                this.textRuns.add(textRun);
                this.adjustTextMatrix(textRun);
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (PDFInvalidDocumentException pDFInvalidDocumentException) {
            // empty catch block
        }
    }

    public void addTextRun(ASArray tjArray, GState gState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            TextRun textRun = new TextRun(tjArray, this.tm, gState, this.pdfDocument, this.ignoreErrors);
            this.textRuns.add(textRun);
            this.adjustTextMatrix(textRun);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (PDFInvalidDocumentException pDFInvalidDocumentException) {
            // empty catch block
        }
    }

    public void addTextRun(ASArray tjArray, GState gState, ActualText actualText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            TextRun textRun = new TextRun(tjArray, this.tm, gState, actualText, this.pdfDocument, this.ignoreErrors);
            this.textRuns.add(textRun);
            this.adjustTextMatrix(textRun);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (PDFInvalidDocumentException pDFInvalidDocumentException) {
            // empty catch block
        }
    }

    void adjustTextMatrix(TextRun textRun) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.tm = this.tm.preMultiply(textRun.txDelta, textRun.tyDelta);
    }

    public ASMatrix getTextMatrix() {
        return this.tm;
    }

    public void setTextMatrix(ASMatrix tm) {
        this.tm = tm;
    }

    public ASMatrix getTextLineMatrix() {
        return this.tlm;
    }

    public void setTextLineMatrix(ASMatrix tlm) {
        this.tlm = tlm;
    }

    ASMatrix getTextRenderingMatrix() {
        return this.trm;
    }

    void setTextRenderingMatrix(ASMatrix trm) {
        this.trm = trm;
    }

    public String toString() {
        return this.textRuns.toString();
    }

    public boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    public void setSkipThisTextObject(boolean skipThisTextObject) {
        this.skipThisTextObject = skipThisTextObject;
    }

    public boolean skipThisTextObject() {
        return this.skipThisTextObject;
    }
}

