/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;

class InlineImageOperator
extends ContentOperator {
    static final int BI = 1;
    static final int ID = 2;
    static final int EI = 3;

    InlineImageOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                opHandlers.BI(instruction);
                break;
            }
            case 2: {
                InputByteStream imageData = opStack.popInputByteStream();
                ASDictionary imageParams = opStack.stackToImageDictionary();
                opHandlers.ID(imageParams, imageData, instruction);
                break;
            }
            case 3: {
                opHandlers.EI(instruction);
            }
        }
    }
}

